/*
 * Decompiled with CFR 0.152.
 */
package com.teamfractal.fracdustry.common.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teamfractal.fracdustry.common.block.impl.machines.FDOreProcessorBlock;
import com.teamfractal.fracdustry.common.config.FDCommonConfig;
import com.teamfractal.fracdustry.common.data.recipes.IOreProcessorRecipe;
import com.teamfractal.fracdustry.common.data.recipes.init.FDRecipeTypes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class OreProcessorRecipe
implements IOreProcessorRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;

    public OreProcessorRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean m_5818_(Container inv, @Nonnull Level world) {
        return ((Ingredient)this.recipeItems.get(0)).test(inv.m_8020_(0));
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    @Nonnull
    public ItemStack m_5874_(@Nonnull Container container) {
        return this.output.m_41777_();
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public static int getProcess() {
        return Math.max((Integer)FDCommonConfig.ORE_PROCESSOR_BASE_PROCESS_TIME.get(), 1);
    }

    @Nonnull
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)FDOreProcessorBlock.BLOCK);
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FDRecipeTypes.recipeSerializerOreProcessor.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<OreProcessorRecipe> {
        @Nonnull
        public OreProcessorRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)1, (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new OreProcessorRecipe(recipeId, output, (NonNullList<Ingredient>)inputs);
        }

        @Nullable
        public OreProcessorRecipe fromNetwork(@Nonnull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < inputs.size(); ++j) {
                inputs.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            return new OreProcessorRecipe(recipeId, output, (NonNullList<Ingredient>)inputs);
        }

        public void toNetwork(FriendlyByteBuf buffer, OreProcessorRecipe recipe) {
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buffer);
            }
            buffer.writeItemStack(recipe.m_8043_(), false);
        }
    }

    public static class OreProcessorRecipeType
    implements RecipeType<OreProcessorRecipe> {
        public String toString() {
            return IOreProcessorRecipe.TYPE_ID.toString();
        }
    }
}

