/*
 * Decompiled with CFR 0.152.
 */
package com.teamfractal.fracdustry.common.util.energynetwork;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Queues;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.teamfractal.fracdustry.common.util.energynetwork.IBlockNetwork;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class BlockNetwork
implements IBlockNetwork {
    private final Map<BlockPos, Set<BlockPos>> components = Maps.newHashMap();
    private final SetMultimap<BlockPos, Direction> connections = Multimaps.newSetMultimap((Map)Maps.newHashMap(), () -> EnumSet.noneOf(Direction.class));

    @Override
    public int size(BlockPos node) {
        return this.components.containsKey(node) ? this.components.get(node).size() : 1;
    }

    @Override
    public BlockPos root(BlockPos node) {
        return this.components.containsKey(node) ? this.components.get(node).iterator().next() : node.m_7949_();
    }

    @Override
    public void cut(BlockPos node, Direction direction, IBlockNetwork.ConnectivityListener afterSplit) {
        if (this.connections.remove((Object)node, (Object)direction)) {
            LinkedHashSet secondaryComponent;
            BlockPos another = node.m_141952_(direction.m_122436_());
            this.connections.remove((Object)another, (Object)direction.m_122424_());
            BFSIterator nodeIterator = new BFSIterator(node);
            BFSIterator anotherIterator = new BFSIterator(another);
            while (nodeIterator.hasNext()) {
                BlockPos next = nodeIterator.next();
                if (!anotherIterator.getSearched().contains(next)) {
                    BFSIterator iterator = anotherIterator;
                    anotherIterator = nodeIterator;
                    nodeIterator = iterator;
                    continue;
                }
                return;
            }
            Set<BlockPos> primaryComponent = this.components.get(node);
            BlockPos primaryNode = primaryComponent.iterator().next();
            LinkedHashSet searched = nodeIterator.getSearched();
            if (searched.contains(primaryNode)) {
                secondaryComponent = Sets.newLinkedHashSet((Iterable)Sets.difference(primaryComponent, searched));
                primaryComponent.retainAll(searched);
            } else {
                secondaryComponent = searched;
                primaryComponent.removeAll(searched);
            }
            if (secondaryComponent.size() <= 1) {
                secondaryComponent.forEach(this.components::remove);
            } else {
                secondaryComponent.forEach(pos -> this.components.put((BlockPos)pos, secondaryComponent));
            }
            if (primaryComponent.size() <= 1) {
                primaryComponent.forEach(this.components::remove);
            }
            afterSplit.onChange(primaryNode, (BlockPos)secondaryComponent.iterator().next());
        }
    }

    @Override
    public void link(BlockPos node, Direction direction, IBlockNetwork.ConnectivityListener beforeMerge) {
        BlockPos secondary = node.m_7949_();
        if (this.connections.put((Object)secondary, (Object)direction)) {
            BlockPos primary = node.m_141952_(direction.m_122436_());
            this.connections.put((Object)primary, (Object)direction.m_122424_());
            Set<BlockPos> primaryComponent = this.components.get(primary);
            Set<BlockPos> secondaryComponent = this.components.get(secondary);
            if (primaryComponent == null && secondaryComponent == null) {
                LinkedHashSet union = Sets.newLinkedHashSet();
                beforeMerge.onChange(secondary, primary);
                this.components.put(secondary, union);
                this.components.put(primary, union);
                union.add(secondary);
                union.add(primary);
            } else if (primaryComponent == null) {
                beforeMerge.onChange(secondaryComponent.iterator().next(), primary);
                this.components.put(primary, secondaryComponent);
                secondaryComponent.add(primary);
            } else if (secondaryComponent == null) {
                beforeMerge.onChange(primaryComponent.iterator().next(), secondary);
                this.components.put(secondary, primaryComponent);
                primaryComponent.add(secondary);
            } else if (primaryComponent != secondaryComponent) {
                beforeMerge.onChange(primaryComponent.iterator().next(), secondaryComponent.iterator().next());
                LinkedHashSet union = Sets.newLinkedHashSet((Iterable)Sets.union(primaryComponent, secondaryComponent));
                union.forEach(pos -> this.components.put((BlockPos)pos, union));
            }
        }
    }

    public class BFSIterator
    implements Iterator<BlockPos> {
        private final Set<BlockPos> searched = Sets.newLinkedHashSet();
        private final Queue<BlockPos> queue = Queues.newArrayDeque();

        public BFSIterator(BlockPos node) {
            node = node.m_7949_();
            this.searched.add(node);
            this.queue.offer(node);
        }

        @Override
        public boolean hasNext() {
            return this.queue.size() > 0;
        }

        @Override
        public BlockPos next() {
            BlockPos node = this.queue.remove();
            for (Direction direction : BlockNetwork.this.connections.get((Object)node)) {
                BlockPos another = node.m_141952_(direction.m_122436_());
                if (!this.searched.add(another)) continue;
                this.queue.offer(another);
            }
            return node;
        }

        public Set<BlockPos> getSearched() {
            return this.searched;
        }
    }
}

