/*
 * Decompiled with CFR 0.152.
 */
package com.teamfractal.fracdustry.common.blockentity.Connectivities;

import com.mojang.datafixers.DSL;
import com.teamfractal.fracdustry.common.block.init.FDBlocks;
import com.teamfractal.fracdustry.common.util.energynetwork.EnergyNetwork;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FDCableBlockEntity
extends BlockEntity {
    public static final String NAME = "fracdustry:cable";
    @ObjectHolder(value="fracdustry:cable")
    public static BlockEntityType<FDCableBlockEntity> BLOCK_ENTITY_TYPE;
    private final LazyOptional<IEnergyStorage> lazyOptional = LazyOptional.of(() -> new IEnergyStorage(){
        private final EnergyNetwork network;
        {
            this.network = EnergyNetwork.Factory.get((LevelAccessor)FDCableBlockEntity.this.f_58857_);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int energy = this.getEnergyStored();
            int diff = Math.min(500, Math.min(this.getMaxEnergyStored() - energy, maxReceive));
            if (!simulate) {
                this.network.addEnergy(FDCableBlockEntity.this.f_58858_, diff);
                if (diff != 0) {
                    FDCableBlockEntity.this.m_6596_();
                }
            }
            return diff;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int energy = this.getEnergyStored();
            int diff = Math.min(500, Math.min(energy, maxExtract));
            if (!simulate) {
                this.network.addEnergy(FDCableBlockEntity.this.f_58858_, -diff);
                if (diff != 0) {
                    FDCableBlockEntity.this.m_6596_();
                }
            }
            return diff;
        }

        public int getEnergyStored() {
            return Math.min(this.getMaxEnergyStored(), this.network.getNetworkEnergy(FDCableBlockEntity.this.f_58858_));
        }

        public int getMaxEnergyStored() {
            return 1000 * this.network.getNetworkSize(FDCableBlockEntity.this.f_58858_);
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    });
    private Integer tmpEnergy = null;

    @SubscribeEvent
    public static void onRegisterBlockEntityType(@Nonnull RegistryEvent.Register<BlockEntityType<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_(FDCableBlockEntity::new, (Block[])new Block[]{(Block)FDBlocks.blockCable.get()}).m_58966_(DSL.remainderType()).setRegistryName(NAME)));
    }

    public FDCableBlockEntity(BlockPos pos, BlockState state) {
        super(BLOCK_ENTITY_TYPE, pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        this.tmpEnergy = compound.m_128451_("WireEnergy");
        super.m_142466_(compound);
    }

    @Nonnull
    public CompoundTag m_6945_(@Nonnull CompoundTag compound) {
        EnergyNetwork network = EnergyNetwork.Factory.get((LevelAccessor)this.f_58857_);
        compound.m_128405_("WireEnergy", network.getSharedEnergy(this.f_58858_));
        return super.m_6945_(compound);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        boolean isEnergy = Objects.equals(cap, CapabilityEnergy.ENERGY);
        return isEnergy ? this.lazyOptional.cast() : super.getCapability(cap, side);
    }

    public void onLoad() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            EnergyNetwork network = EnergyNetwork.Factory.get((LevelAccessor)this.f_58857_);
            if (this.tmpEnergy != null) {
                int diff = this.tmpEnergy - network.getSharedEnergy(this.f_58858_);
                network.addEnergy(this.f_58858_, diff);
                this.tmpEnergy = null;
            }
            network.enableBlock(this.f_58858_, () -> ((FDCableBlockEntity)this).m_6596_());
        }
        super.onLoad();
    }

    public void onChunkUnloaded() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            EnergyNetwork network = EnergyNetwork.Factory.get((LevelAccessor)this.f_58857_);
            network.disableBlock(this.f_58858_, () -> ((FDCableBlockEntity)this).m_6596_());
        }
        super.onChunkUnloaded();
    }

    public void m_7651_() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            EnergyNetwork network = EnergyNetwork.Factory.get((LevelAccessor)this.f_58857_);
            network.disableBlock(this.f_58858_, () -> {
                int diff = network.getSharedEnergy(this.f_58858_);
                network.addEnergy(this.f_58858_, -diff);
                this.m_6596_();
            });
        }
        super.m_7651_();
    }
}

