/*
 * Decompiled with CFR 0.152.
 */
package com.teamfractal.fracdustry.common.blockentity.Generators;

import com.google.common.collect.Queues;
import com.mojang.datafixers.DSL;
import com.teamfractal.fracdustry.common.block.impl.generators.FDKineticGeneratorBlock;
import com.teamfractal.fracdustry.common.container.Generators.FDKineticGeneratorContainer;
import com.teamfractal.fracdustry.common.container.datasync.SimpleArray;
import com.teamfractal.fracdustry.common.util.energystorage.FDEnergyStorage;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FDKineticGeneratorBlockEntity
extends BlockEntity
implements MenuProvider,
IAnimatable {
    public static final String NAME = "fracdustry:kinetic_generator";
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    @ObjectHolder(value="fracdustry:kinetic_generator")
    public static BlockEntityType<FDKineticGeneratorBlockEntity> BLOCK_ENTITY_TYPE;
    private final FDEnergyStorage energyStorage = this.createEnergy();
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    private int en = 0;
    private SimpleArray currentEnergy = new SimpleArray();
    private SimpleArray maxEnergy = new SimpleArray();
    private final Queue<Direction> directionQueue = Queues.newArrayDeque((Iterable)Direction.Plane.HORIZONTAL);

    @SubscribeEvent
    public static void onRegisterBlockEntityType(@Nonnull RegistryEvent.Register<BlockEntityType<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_(FDKineticGeneratorBlockEntity::new, (Block[])new Block[]{FDKineticGeneratorBlock.BLOCK}).m_58966_(DSL.remainderType()).setRegistryName(NAME)));
    }

    @Nonnull
    public Component m_5446_() {
        return new TextComponent("");
    }

    public AbstractContainerMenu m_7208_(int windowId, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        if (this.f_58857_ != null) {
            return new FDKineticGeneratorContainer(windowId, this.f_58857_, this.f_58858_, playerInventory, playerEntity, this.currentEnergy, this.maxEnergy);
        }
        return null;
    }

    public void m_7651_() {
        super.m_7651_();
        this.energy.invalidate();
    }

    public void tickServer(BlockState state) {
        BlockState blockState = null;
        if (this.f_58857_ != null) {
            blockState = this.f_58857_.m_8055_(this.f_58858_);
        }
        if (blockState != null && !((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)), 3);
        }
        this.m_6596_();
        this.sendOutPower();
    }

    private <E extends BlockEntity> PlayState predicate(AnimationEvent<E> event) {
        event.getController().transitionLengthTicks = 0.0;
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.kinetic_generator.spin", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    private void sendOutPower() {
        AtomicInteger capacity = new AtomicInteger(this.energyStorage.getEnergyStored());
        if (capacity.get() > 0) {
            this.directionQueue.offer(this.directionQueue.remove());
            for (Direction direction : this.directionQueue) {
                boolean doContinue;
                BlockEntity te = null;
                if (this.f_58857_ != null && (direction == ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_() || direction == ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)).m_122428_())) {
                    te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(direction));
                }
                if (te == null || (doContinue = te.getCapability(CapabilityEnergy.ENERGY, direction.m_122424_()).map(handler -> {
                    if (handler.canReceive()) {
                        int received = handler.receiveEnergy(Math.min(capacity.get(), 100), false);
                        capacity.addAndGet(-received);
                        this.energyStorage.consumeEnergy(received);
                        this.en = this.energyStorage.getEnergyStored();
                        this.m_6596_();
                        return capacity.get() > 0;
                    }
                    return true;
                }).orElse(true).booleanValue())) continue;
                return;
            }
        }
        this.currentEnergy.m_8050_(0, this.energyStorage.getEnergyStored());
        this.maxEnergy.m_8050_(0, this.energyStorage.getMaxEnergyStored());
    }

    public FDKineticGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super(BLOCK_ENTITY_TYPE, pos, state);
    }

    @Nonnull
    public CompoundTag m_6945_(@Nonnull CompoundTag tag) {
        tag.m_128405_("energy", this.en);
        return super.m_6945_(tag);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        this.en = tag.m_128451_("energy");
        super.m_142466_(tag);
    }

    private FDEnergyStorage createEnergy() {
        return new FDEnergyStorage(2500, 2500){

            @Override
            protected void onEnergyChanged() {
                FDKineticGeneratorBlockEntity.this.m_6596_();
            }

            public boolean canExtract() {
                return true;
            }
        };
    }

    public void manuallyGenerateEnergy(@Nullable BlockEntity blockentity, BlockPos pos) {
        if (!(blockentity instanceof FDKineticGeneratorBlockEntity) || pos == this.f_58858_) {
            // empty if block
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            boolean isValid = side != null && side.m_122434_().m_122479_() && (side == ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_() || side == ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)).m_122428_()) || side == Direction.UP;
            return isValid ? this.energy.cast() : super.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

