/*
 * Decompiled with CFR 0.152.
 */
package com.teamfractal.fracdustry.common.blockentity.Machines;

import com.mojang.datafixers.DSL;
import com.teamfractal.fracdustry.common.block.impl.machines.FDElectricFurnaceBlock;
import com.teamfractal.fracdustry.common.config.FDCommonConfig;
import com.teamfractal.fracdustry.common.container.Machines.FDElectricFurnaceContainer;
import com.teamfractal.fracdustry.common.container.datasync.SimpleArray;
import com.teamfractal.fracdustry.common.sound.FDSounds;
import com.teamfractal.fracdustry.common.util.energystorage.FDEnergyStorage;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FDElectricFurnaceBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final String NAME = "fracdustry:electric_furnace";
    @ObjectHolder(value="fracdustry:electric_furnace")
    public static BlockEntityType<FDElectricFurnaceBlockEntity> BLOCK_ENTITY_TYPE;
    private final ItemStackHandler itemHandler = this.createHandler();
    private final FDEnergyStorage energyStorage = this.createEnergy();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    private boolean canCraft;
    private int timer;
    private SimpleArray processNow = new SimpleArray();
    private SimpleArray processTotal = new SimpleArray();
    private SimpleArray currentEnergy = new SimpleArray();
    private SimpleArray maxEnergy = new SimpleArray();

    @SubscribeEvent
    public static void onRegisterBlockEntityType(@Nonnull RegistryEvent.Register<BlockEntityType<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_(FDElectricFurnaceBlockEntity::new, (Block[])new Block[]{FDElectricFurnaceBlock.BLOCK}).m_58966_(DSL.remainderType()).setRegistryName(NAME)));
    }

    @Nonnull
    public Component m_5446_() {
        return new TextComponent("");
    }

    public AbstractContainerMenu m_7208_(int windowId, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        if (this.f_58857_ != null) {
            return new FDElectricFurnaceContainer(windowId, this.f_58857_, this.f_58858_, playerInventory, playerEntity, this.processNow, this.processTotal, this.currentEnergy, this.maxEnergy);
        }
        return null;
    }

    public void m_7651_() {
        super.m_7651_();
        this.handler.invalidate();
        this.energy.invalidate();
    }

    public boolean canProcess(@Nullable Optional<SmeltingRecipe> recipeIn) {
        if (recipeIn != null) {
            if (!this.itemHandler.getStackInSlot(0).m_41619_() && recipeIn.isPresent()) {
                ItemStack itemstack = recipeIn.get().m_8043_().m_41777_();
                if (itemstack.m_41619_()) {
                    return false;
                }
                ItemStack itemstack1 = this.itemHandler.getStackInSlot(1);
                if (itemstack1.m_41619_()) {
                    return true;
                }
                if (!itemstack1.m_41656_(itemstack)) {
                    return false;
                }
                if (itemstack1.m_41613_() + itemstack.m_41613_() <= 64 && itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack1.m_41741_()) {
                    return true;
                }
                return itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack.m_41741_();
            }
            return false;
        }
        return false;
    }

    public void tickServer(BlockState state) {
        boolean isPowered;
        SimpleContainer inv = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inv.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Optional recipe = this.f_58857_ != null ? this.f_58857_.m_7465_().m_44015_(RecipeType.f_44108_, (Container)inv, this.f_58857_) : Optional.empty();
        int t = Math.max((int)((double)recipe.map(AbstractCookingRecipe::m_43753_).orElse(10000).intValue() * (Double)FDCommonConfig.ELECTRIC_FURNACE_PROCESS_TIME_COEFFICIENT.get()), 1);
        if (!this.canProcess(recipe)) {
            this.canCraft = false;
            this.timer = 0;
            this.m_6596_();
        }
        if (this.timer <= 0) {
            if (this.canCraft && this.canProcess(recipe)) {
                this.craft();
                this.canCraft = false;
                this.m_6596_();
            }
            if (t > 0 && recipe.isPresent()) {
                this.timer = t;
                this.canCraft = true;
                this.m_6596_();
            }
        }
        if (this.timer > 0 && this.energyStorage.getEnergyStored() > 5) {
            this.processNow.m_8050_(0, this.timer);
            --this.timer;
            this.energyStorage.consumeEnergy(5);
            this.m_6596_();
            if (this.f_58857_ != null && this.f_58857_.m_46467_() % 20L == 0L && this.canProcess(recipe)) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)FDSounds.electric_furnace_loop.get(), SoundSource.BLOCKS, 0.2f, 1.0f);
            }
        }
        this.m_6596_();
        this.processTotal.m_8050_(0, recipe.map(AbstractCookingRecipe::m_43753_).orElse(10000));
        this.currentEnergy.m_8050_(0, this.energyStorage.getEnergyStored());
        this.maxEnergy.m_8050_(0, this.energyStorage.getMaxEnergyStored());
        BlockState blockState = null;
        if (this.f_58857_ != null) {
            blockState = this.f_58857_.m_8055_(this.f_58858_);
        }
        boolean bl = isPowered = this.timer > 0 && this.energyStorage.getEnergyStored() > 5 && this.canCraft;
        if (blockState != null && (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61448_) != isPowered) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(isPowered)), 3);
        }
    }

    public FDElectricFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super(BLOCK_ENTITY_TYPE, pos, state);
    }

    @Nonnull
    public CompoundTag m_6945_(@Nonnull CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        tag.m_128365_("energy", this.energyStorage.serializeNBT());
        tag.m_128405_("timer", this.timer);
        return super.m_6945_(tag);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        this.itemHandler.deserializeNBT(tag.m_128469_("inv"));
        this.energyStorage.deserializeNBT((Tag)((IntTag)tag.m_128423_("energy")));
        this.timer = tag.m_128451_("timer");
        super.m_142466_(tag);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                FDElectricFurnaceBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }
        };
    }

    private FDEnergyStorage createEnergy() {
        return new FDEnergyStorage(50000, 500){

            @Override
            protected void onEnergyChanged() {
                FDElectricFurnaceBlockEntity.this.m_6596_();
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            boolean isValid = side == Direction.UP;
            return isValid ? this.handler.cast() : super.getCapability(cap, side);
        }
        if (cap == CapabilityEnergy.ENERGY) {
            boolean isValid = side != null && side.m_122434_().m_122479_() && side.m_122424_() == this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
            return isValid ? this.energy.cast() : super.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public void craft() {
        SimpleContainer inv = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inv.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Optional recipe = this.f_58857_ != null ? this.f_58857_.m_7465_().m_44015_(RecipeType.f_44108_, (Container)inv, this.f_58857_) : Optional.empty();
        recipe.ifPresent(iRecipe -> {
            ItemStack output = iRecipe.m_5874_((Container)inv);
            this.craftTheItem(output);
            this.m_6596_();
        });
    }

    private void craftTheItem(ItemStack output) {
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.insertItem(1, output, false);
    }
}

