/*
 * Decompiled with CFR 0.152.
 */
package com.teamfractal.fracdustry.common.fluid.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;

public class RedactedLiquidBlock
extends Block
implements BucketPickup {
    protected final FlowingFluid fluid = null;
    public static final IntegerProperty LEVEL = BlockStateProperties.f_61422_;
    private final List<FluidState> stateCache = Lists.newArrayList();
    public static final VoxelShape STABLE_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final ImmutableList<Direction> POSSIBLE_FLOW_DIRECTIONS = ImmutableList.of((Object)Direction.DOWN, (Object)Direction.SOUTH, (Object)Direction.NORTH, (Object)Direction.EAST, (Object)Direction.WEST);
    private final Supplier<? extends Fluid> supplier;
    private boolean fluidStateCacheInitialized = false;

    public RedactedLiquidBlock(Supplier<? extends FlowingFluid> p_54694_, BlockBehaviour.Properties p_54695_) {
        super(p_54695_);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
        this.supplier = p_54694_;
    }

    @Nonnull
    public VoxelShape m_5939_(@Nonnull BlockState p_54760_, @Nonnull BlockGetter p_54761_, @Nonnull BlockPos p_54762_, CollisionContext p_54763_) {
        return p_54763_.m_6513_(STABLE_SHAPE, p_54762_, true) && (Integer)p_54760_.m_61143_((Property)LEVEL) == 0 && p_54763_.m_7875_(p_54761_.m_6425_(p_54762_.m_7494_()), this.getFluid()) ? STABLE_SHAPE : Shapes.m_83040_();
    }

    public boolean m_6724_(BlockState p_54732_) {
        return p_54732_.m_60819_().m_76187_();
    }

    public void m_7455_(BlockState p_54740_, @Nonnull ServerLevel p_54741_, @Nonnull BlockPos p_54742_, @Nonnull Random p_54743_) {
        p_54740_.m_60819_().m_76174_((Level)p_54741_, p_54742_, p_54743_);
    }

    public boolean m_7420_(@Nonnull BlockState p_54745_, @Nonnull BlockGetter p_54746_, @Nonnull BlockPos p_54747_) {
        return false;
    }

    public boolean m_7357_(@Nonnull BlockState p_54704_, @Nonnull BlockGetter p_54705_, @Nonnull BlockPos p_54706_, @Nonnull PathComputationType p_54707_) {
        return !this.getFluid().m_76108_((Tag)FluidTags.f_13132_);
    }

    @Nonnull
    public FluidState m_5888_(BlockState p_54765_) {
        int i = (Integer)p_54765_.m_61143_((Property)LEVEL);
        if (!this.fluidStateCacheInitialized) {
            this.initFluidStateCache();
        }
        return this.stateCache.get(Math.min(i, 8));
    }

    public boolean m_6104_(@Nonnull BlockState p_54716_, BlockState p_54717_, @Nonnull Direction p_54718_) {
        return p_54717_.m_60819_().m_76152_().m_6212_((Fluid)this.getFluid());
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState p_54738_) {
        return RenderShape.INVISIBLE;
    }

    @Nonnull
    public List<ItemStack> m_7381_(@Nonnull BlockState p_54720_, @Nonnull LootContext.Builder p_54721_) {
        return Collections.emptyList();
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState p_54749_, @Nonnull BlockGetter p_54750_, @Nonnull BlockPos p_54751_, @Nonnull CollisionContext p_54752_) {
        return Shapes.m_83040_();
    }

    public void m_6807_(@Nonnull BlockState p_54754_, @Nonnull Level p_54755_, @Nonnull BlockPos p_54756_, @Nonnull BlockState p_54757_, boolean p_54758_) {
        if (this.shouldSpreadLiquid(p_54755_, p_54756_, p_54754_)) {
            p_54755_.m_6217_().m_5945_(p_54756_, (Object)p_54754_.m_60819_().m_76152_(), this.getFluid().m_6718_((LevelReader)p_54755_));
        }
    }

    @Nonnull
    public BlockState m_7417_(BlockState p_54723_, @Nonnull Direction p_54724_, @Nonnull BlockState p_54725_, @Nonnull LevelAccessor p_54726_, @Nonnull BlockPos p_54727_, @Nonnull BlockPos p_54728_) {
        if (p_54723_.m_60819_().m_76170_() || p_54725_.m_60819_().m_76170_()) {
            p_54726_.m_6217_().m_5945_(p_54727_, (Object)p_54723_.m_60819_().m_76152_(), this.getFluid().m_6718_((LevelReader)p_54726_));
        }
        return super.m_7417_(p_54723_, p_54724_, p_54725_, p_54726_, p_54727_, p_54728_);
    }

    public void m_6861_(@Nonnull BlockState p_54709_, @Nonnull Level p_54710_, @Nonnull BlockPos p_54711_, @Nonnull Block p_54712_, @Nonnull BlockPos p_54713_, boolean p_54714_) {
        if (this.shouldSpreadLiquid(p_54710_, p_54711_, p_54709_)) {
            p_54710_.m_6217_().m_5945_(p_54711_, (Object)p_54709_.m_60819_().m_76152_(), this.getFluid().m_6718_((LevelReader)p_54710_));
        }
    }

    private boolean shouldSpreadLiquid(Level p_54697_, BlockPos p_54698_, BlockState p_54699_) {
        if (this.getFluid().m_76108_((Tag)FluidTags.f_13132_)) {
            boolean flag = p_54697_.m_8055_(p_54698_.m_7495_()).m_60713_(Blocks.f_50136_);
            for (Direction direction : POSSIBLE_FLOW_DIRECTIONS) {
                BlockPos blockpos = p_54698_.m_142300_(direction.m_122424_());
                if (p_54697_.m_6425_(blockpos).m_76153_((Tag)FluidTags.f_13131_)) {
                    Block block = p_54697_.m_6425_(p_54698_).m_76170_() ? Blocks.f_50080_ : Blocks.f_50652_;
                    p_54697_.m_46597_(p_54698_, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)p_54697_, (BlockPos)p_54698_, (BlockPos)p_54698_, (BlockState)block.m_49966_()));
                    this.fizz((LevelAccessor)p_54697_, p_54698_);
                    return false;
                }
                if (!flag || !p_54697_.m_8055_(blockpos).m_60713_(Blocks.f_50568_)) continue;
                p_54697_.m_46597_(p_54698_, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)p_54697_, (BlockPos)p_54698_, (BlockPos)p_54698_, (BlockState)Blocks.f_50137_.m_49966_()));
                this.fizz((LevelAccessor)p_54697_, p_54698_);
                return false;
            }
        }
        return true;
    }

    private void fizz(LevelAccessor p_54701_, BlockPos p_54702_) {
        p_54701_.m_46796_(1501, p_54702_, 0);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_54730_) {
        p_54730_.m_61104_(new Property[]{LEVEL});
    }

    @Nonnull
    public ItemStack m_142598_(@Nonnull LevelAccessor p_153772_, @Nonnull BlockPos p_153773_, @Nonnull BlockState p_153774_) {
        if ((Integer)p_153774_.m_61143_((Property)LEVEL) == 0) {
            p_153772_.m_7731_(p_153773_, Blocks.f_50016_.m_49966_(), 11);
            return new ItemStack((ItemLike)this.getFluid().m_6859_());
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public FlowingFluid getFluid() {
        return (FlowingFluid)this.supplier.get();
    }

    protected synchronized void initFluidStateCache() {
        if (!this.fluidStateCacheInitialized) {
            this.stateCache.add(this.getFluid().m_76068_(false));
            for (int i = 1; i < 8; ++i) {
                this.stateCache.add(this.getFluid().m_75953_(8 - i, false));
            }
            this.stateCache.add(this.getFluid().m_75953_(8, true));
            this.fluidStateCacheInitialized = true;
        }
    }

    @Nonnull
    public Optional<SoundEvent> m_142298_() {
        return Optional.of(SoundEvents.f_11781_);
    }
}

