/*
 * Decompiled with CFR 0.152.
 */
package com.teamfractal.fracdustry.common.util.energynetwork;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Queues;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.teamfractal.fracdustry.common.block.impl.connectivities.FDCableBlock;
import com.teamfractal.fracdustry.common.block.init.FDBlocks;
import com.teamfractal.fracdustry.common.util.energynetwork.BlockNetwork;
import com.teamfractal.fracdustry.common.util.energynetwork.IBlockNetwork;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

public class EnergyNetwork {
    private final LevelAccessor world;
    private final IBlockNetwork blockNetwork;
    private final Queue<Runnable> taskCollection;
    private final Multiset<BlockPos> energyCollection;
    private final SetMultimap<ChunkPos, BlockPos> chunkCollection;
    private final SetMultimap<BlockPos, Direction> machineCollection;

    private EnergyNetwork(LevelAccessor world, IBlockNetwork blockNetwork) {
        this.world = world;
        this.blockNetwork = blockNetwork;
        this.taskCollection = Queues.newArrayDeque();
        this.energyCollection = HashMultiset.create();
        this.chunkCollection = Multimaps.newSetMultimap((Map)Maps.newHashMap(), Sets::newHashSet);
        this.machineCollection = Multimaps.newSetMultimap((Map)Maps.newHashMap(), () -> EnumSet.noneOf(Direction.class));
    }

    public int getNetworkSize(BlockPos pos) {
        return this.blockNetwork.size(pos);
    }

    public int getNetworkEnergy(BlockPos pos) {
        BlockPos root = this.blockNetwork.root(pos);
        return this.energyCollection.count((Object)root);
    }

    public int getSharedEnergy(BlockPos pos) {
        int size = this.blockNetwork.size(pos);
        BlockPos root = this.blockNetwork.root(pos);
        int total = this.energyCollection.count((Object)root);
        return root.equals((Object)pos) ? total / size + total % size : total / size;
    }

    public void addEnergy(BlockPos pos, int diff) {
        if (diff >= 0) {
            this.energyCollection.add((Object)this.blockNetwork.root(pos), diff);
        } else {
            this.energyCollection.remove((Object)this.blockNetwork.root(pos), -diff);
        }
    }

    public void disableBlock(BlockPos pos, Runnable callback) {
        this.taskCollection.offer(() -> {
            this.chunkCollection.remove((Object)new ChunkPos(pos), (Object)pos);
            for (Direction side : Direction.values()) {
                this.blockNetwork.cut(pos, side, this::afterSplit);
            }
            this.machineCollection.removeAll((Object)pos);
            callback.run();
        });
    }

    public void enableBlock(BlockPos pos, Runnable callback) {
        this.taskCollection.offer(() -> {
            this.chunkCollection.put((Object)new ChunkPos(pos), (Object)pos.m_7949_());
            for (Direction side : Direction.values()) {
                if (this.hasWireConnection(pos, side)) {
                    if (this.hasWireConnection(pos.m_141952_(side.m_122436_()), side.m_122424_())) {
                        this.machineCollection.remove((Object)pos, (Object)side);
                        this.blockNetwork.link(pos, side, this::beforeMerge);
                        continue;
                    }
                    this.machineCollection.put((Object)pos.m_7949_(), (Object)side);
                    this.blockNetwork.cut(pos, side, this::afterSplit);
                    continue;
                }
                this.machineCollection.remove((Object)pos, (Object)side);
                this.blockNetwork.cut(pos, side, this::afterSplit);
            }
            callback.run();
        });
    }

    private boolean hasWireConnection(BlockPos pos, Direction side) {
        if (this.world.m_46805_(pos)) {
            BlockState state = this.world.m_8055_(pos);
            return state.m_60734_().equals(FDBlocks.blockCable.get()) && (Boolean)state.m_61143_((Property)FDCableBlock.PROPERTY_MAP.get(side)) != false;
        }
        return false;
    }

    private void afterSplit(BlockPos primaryNode, BlockPos secondaryNode) {
        int primarySize = this.blockNetwork.size(primaryNode);
        int secondarySize = this.blockNetwork.size(secondaryNode);
        int diff = this.energyCollection.count((Object)primaryNode) * secondarySize / (primarySize + secondarySize);
        this.energyCollection.remove((Object)primaryNode, diff);
        this.energyCollection.add((Object)secondaryNode, diff);
    }

    private void beforeMerge(BlockPos primaryNode, BlockPos secondaryNode) {
        int diff = this.energyCollection.count((Object)secondaryNode);
        this.energyCollection.remove((Object)secondaryNode, diff);
        this.energyCollection.add((Object)primaryNode, diff);
    }

    private void markDirty() {
        for (ChunkPos chunkPos : this.chunkCollection.keys()) {
            BlockPos pos = chunkPos.m_45615_();
            if (!this.world.m_46805_(pos)) continue;
            this.world.m_46865_(pos).m_8092_(true);
        }
    }

    private void tickStart() {
        Runnable runnable = this.taskCollection.poll();
        while (runnable != null) {
            runnable.run();
            runnable = this.taskCollection.poll();
        }
    }

    private void tickEnd() {
        for (Map.Entry entry : this.shuffled(this.machineCollection.entries())) {
            BlockEntity tileEntity;
            Direction direction = (Direction)entry.getValue();
            BlockPos node = (BlockPos)entry.getKey();
            BlockPos root = this.blockNetwork.root(node);
            if (!this.world.m_46805_(node.m_141952_(direction.m_122436_())) || (tileEntity = this.world.m_7702_(node.m_141952_(direction.m_122436_()))) == null) continue;
            tileEntity.getCapability(CapabilityEnergy.ENERGY, direction.m_122424_()).ifPresent(e -> {
                if (e.canReceive()) {
                    int diff = this.energyCollection.count((Object)root);
                    this.energyCollection.remove((Object)root, e.receiveEnergy(diff, false));
                }
            });
        }
    }

    private <T> List<T> shuffled(Iterable<? extends T> iterable) {
        ArrayList list = Lists.newArrayList(iterable);
        Random rand = this.world.m_5822_();
        Collections.shuffle(list, rand);
        return list;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Factory {
        private static final Map<LevelAccessor, EnergyNetwork> INSTANCES = Maps.newIdentityHashMap();

        public static EnergyNetwork get(LevelAccessor world) {
            return INSTANCES.computeIfAbsent(world, k -> new EnergyNetwork((LevelAccessor)k, new BlockNetwork()));
        }

        @SubscribeEvent
        public static void onSave(WorldEvent.Save event) {
            if (INSTANCES.containsKey(event.getWorld())) {
                INSTANCES.get(event.getWorld()).markDirty();
            }
        }

        @SubscribeEvent
        public static void onUnload(WorldEvent.Unload event) {
            INSTANCES.remove(event.getWorld());
        }

        @SubscribeEvent
        public static void onWorldTick(TickEvent.WorldTickEvent event) {
            if (LogicalSide.SERVER.equals((Object)event.side)) {
                switch (event.phase) {
                    case START: {
                        Factory.get((LevelAccessor)event.world).tickStart();
                        break;
                    }
                    case END: {
                        Factory.get((LevelAccessor)event.world).tickEnd();
                        break;
                    }
                }
            }
        }
    }
}

