/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.noise.module.combiner.selector;

import com.flowpowered.noise.Utils;
import com.flowpowered.noise.module.Module;
import com.flowpowered.noise.module.combiner.selector.Selector;

public class Blend
extends Selector {
    public Blend(Module control, Module sourceA, Module sourceB) {
        super(control, sourceA, sourceB);
    }

    @Override
    public double getValue(double x, double y, double z) {
        double v0 = this.sourceA.getValue(x, y, z);
        double v1 = this.sourceB.getValue(x, y, z);
        double alpha = (this.control.getValue(x, y, z) + 1.0) / 2.0;
        return Utils.linearInterp(v0, v1, alpha);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Selector.Builder {
        @Override
        public Builder setSourceA(Module sourceA) {
            super.setSourceA(sourceA);
            return this;
        }

        @Override
        public Builder setSourceB(Module sourceA) {
            super.setSourceA(sourceA);
            return this;
        }

        @Override
        public Builder setSources(Module sourceA, Module sourceB) {
            super.setSources(sourceA, sourceB);
            return this;
        }

        @Override
        public Builder setControl(Module control) {
            this.control = control;
            return this;
        }

        @Override
        public Blend build() throws IllegalStateException {
            this.checkValues();
            return new Blend(this.control, this.sourceA, this.sourceB);
        }
    }
}

