/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.manipulator.immutable.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;

public abstract class AbstractImmutableSingleData<T, I extends ImmutableDataManipulator<I, M>, M extends DataManipulator<M, I>>
extends AbstractImmutableData<I, M> {
    protected final Key<? extends BaseValue<T>> usedKey;
    protected final T value;
    protected final T defaultValue;

    @Deprecated
    protected AbstractImmutableSingleData(T value, Key<? extends BaseValue<T>> usedKey) {
        this(usedKey, value, value);
    }

    protected AbstractImmutableSingleData(Key<? extends Value<T>> usedKey, T value) {
        this(usedKey, value, value);
    }

    protected AbstractImmutableSingleData(Key<? extends Value<T>> usedKey, T value, T defaultValue) {
        this.value = Preconditions.checkNotNull(value, (Object)"value");
        this.defaultValue = Preconditions.checkNotNull(defaultValue, (Object)"defaultValue");
        this.usedKey = (Key)Preconditions.checkNotNull(usedKey, (Object)"usedKey");
        this.registerGetters();
    }

    protected abstract ImmutableValue<?> getValueGetter();

    protected final T getValue() {
        return this.value;
    }

    @Override
    public abstract M asMutable();

    @Override
    protected final void registerGetters() {
        this.registerFieldGetter(this.usedKey, this::getValue);
        this.registerKeyValue(this.usedKey, this::getValueGetter);
    }

    @Override
    public <E> Optional<E> get(Key<? extends BaseValue<E>> key) {
        return ((Key)Preconditions.checkNotNull(key)).equals(this.usedKey) ? Optional.of(this.value) : Optional.empty();
    }

    @Override
    public boolean supports(Key<?> key) {
        return Preconditions.checkNotNull(key) == this.usedKey;
    }

    @Override
    public Set<Key<?>> getKeys() {
        return ImmutableSet.of(this.usedKey);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Objects.hashCode(this.value);
        hash = 31 * hash + Objects.hashCode(this.defaultValue);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        AbstractImmutableSingleData other = (AbstractImmutableSingleData)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.defaultValue, other.defaultValue);
    }
}

