/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableFuseData;
import org.spongepowered.api.data.manipulator.mutable.entity.FuseData;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeFuseData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public class ImmutableSpongeFuseData
extends AbstractImmutableData<ImmutableFuseData, FuseData>
implements ImmutableFuseData {
    private final int fuseDuration;
    private final int ticksRemaining;
    private final ImmutableSpongeValue<Integer> fuseDurationValue;
    private final ImmutableSpongeValue<Integer> ticksRemainingValue;

    public ImmutableSpongeFuseData(int fuseDuration, int ticksRemaining) {
        super(ImmutableFuseData.class);
        this.fuseDuration = fuseDuration;
        this.fuseDurationValue = new ImmutableSpongeValue<Integer>(Keys.FUSE_DURATION, fuseDuration);
        this.ticksRemaining = ticksRemaining;
        this.ticksRemainingValue = new ImmutableSpongeValue<Integer>(Keys.TICKS_REMAINING, ticksRemaining);
        this.registerGetters();
    }

    public ImmutableSpongeFuseData() {
        this(0, 0);
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.FUSE_DURATION, () -> this.fuseDuration);
        this.registerKeyValue(Keys.FUSE_DURATION, this::fuseDuration);
        this.registerFieldGetter(Keys.TICKS_REMAINING, () -> this.ticksRemaining);
        this.registerKeyValue(Keys.TICKS_REMAINING, this::ticksRemaining);
    }

    @Override
    public ImmutableValue<Integer> fuseDuration() {
        return this.fuseDurationValue;
    }

    @Override
    public ImmutableValue<Integer> ticksRemaining() {
        return this.ticksRemainingValue;
    }

    @Override
    public FuseData asMutable() {
        return new SpongeFuseData(this.fuseDuration, this.ticksRemaining);
    }
}

