/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.block;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableWireAttachmentData;
import org.spongepowered.api.data.manipulator.mutable.block.WireAttachmentData;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.type.WireAttachmentType;
import org.spongepowered.api.data.type.WireAttachmentTypes;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.util.Direction;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeWireAttachmentData;
import org.spongepowered.common.data.manipulator.mutable.block.SpongeWireAttachmentData;
import org.spongepowered.common.data.processor.common.AbstractMultiDataProcessor;

public class WireAttachmentDataProcessor
extends AbstractMultiDataProcessor<WireAttachmentData, ImmutableWireAttachmentData> {
    @Override
    protected WireAttachmentData createManipulator() {
        return new SpongeWireAttachmentData();
    }

    @Override
    public Optional<WireAttachmentData> fill(DataContainer container, WireAttachmentData data) {
        if (container.contains(Keys.WIRE_ATTACHMENT_NORTH) && container.contains(Keys.WIRE_ATTACHMENT_SOUTH) && container.contains(Keys.WIRE_ATTACHMENT_EAST) && container.contains(Keys.WIRE_ATTACHMENT_WEST)) {
            data.set(Keys.WIRE_ATTACHMENT_NORTH, container.getCatalogType(Keys.WIRE_ATTACHMENT_NORTH.getQuery(), WireAttachmentType.class).get());
            data.set(Keys.WIRE_ATTACHMENT_SOUTH, container.getCatalogType(Keys.WIRE_ATTACHMENT_SOUTH.getQuery(), WireAttachmentType.class).get());
            data.set(Keys.WIRE_ATTACHMENT_EAST, container.getCatalogType(Keys.WIRE_ATTACHMENT_EAST.getQuery(), WireAttachmentType.class).get());
            data.set(Keys.WIRE_ATTACHMENT_WEST, container.getCatalogType(Keys.WIRE_ATTACHMENT_WEST.getQuery(), WireAttachmentType.class).get());
            return Optional.of(data);
        }
        return Optional.empty();
    }

    @Override
    public DataTransactionResult set(DataHolder dataHolder, WireAttachmentData manipulator, MergeFunction function) {
        return DataTransactionResult.failNoData();
    }

    @Override
    public Optional<ImmutableWireAttachmentData> with(Key<? extends BaseValue<?>> key, Object value, ImmutableWireAttachmentData immutable) {
        HashMap map = Maps.newHashMap(((ImmutableSpongeWireAttachmentData)immutable).getWireAttachmentMap());
        if (key == Keys.WIRE_ATTACHMENTS) {
            for (Direction dir : map.keySet()) {
                map.put(dir, ((Map)value).getOrDefault((Object)dir, WireAttachmentTypes.NONE));
            }
        } else if (key == Keys.WIRE_ATTACHMENT_NORTH) {
            map.put(Direction.NORTH, (WireAttachmentType)value);
        } else if (key == Keys.WIRE_ATTACHMENT_SOUTH) {
            map.put(Direction.SOUTH, (WireAttachmentType)value);
        } else if (key == Keys.WIRE_ATTACHMENT_EAST) {
            map.put(Direction.EAST, (WireAttachmentType)value);
        } else if (key == Keys.WIRE_ATTACHMENT_WEST) {
            map.put(Direction.WEST, (WireAttachmentType)value);
        } else {
            return Optional.empty();
        }
        return Optional.of(new ImmutableSpongeWireAttachmentData(map));
    }

    @Override
    public boolean supports(DataHolder dataHolder) {
        return false;
    }

    @Override
    public Optional<WireAttachmentData> from(DataHolder dataHolder) {
        return Optional.empty();
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

