/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.EntityAgeable;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.util.Constants;

public class AgeValueProcessor
extends AbstractSpongeValueProcessor<EntityAgeable, Integer, MutableBoundedValue<Integer>> {
    public AgeValueProcessor() {
        super(EntityAgeable.class, Keys.AGE);
    }

    @Override
    public MutableBoundedValue<Integer> constructValue(Integer age) {
        return SpongeValueFactory.boundedBuilder(Keys.AGE).comparator(Constants.Functional.intComparator()).minimum(Integer.MIN_VALUE).maximum(Integer.MAX_VALUE).defaultValue(0).actualValue(age).build();
    }

    @Override
    protected boolean set(EntityAgeable container, Integer value) {
        container.func_70873_a(value.intValue());
        return true;
    }

    @Override
    protected Optional<Integer> getVal(EntityAgeable container) {
        return Optional.of(container.func_70874_b());
    }

    @Override
    protected ImmutableBoundedValue<Integer> constructImmutableValue(Integer value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    public Optional<MutableBoundedValue<Integer>> getApiValueFromContainer(ValueContainer<?> container) {
        Optional<Integer> value;
        if (this.supports(container) && (value = this.getVal((EntityAgeable)container)).isPresent()) {
            return Optional.of(this.constructValue(value.get()));
        }
        return Optional.empty();
    }

    @Override
    public boolean supports(ValueContainer<?> container) {
        return container instanceof EntityAgeable;
    }

    @Override
    public DataTransactionResult offerToStore(ValueContainer<?> container, Integer value) {
        ImmutableBoundedValue<Integer> proposedValue = this.constructImmutableValue(value);
        if (this.supports(container)) {
            DataTransactionResult.Builder builder = DataTransactionResult.builder();
            ImmutableValue newAgeValue = SpongeValueFactory.boundedBuilder(Keys.AGE).defaultValue(0).minimum(Integer.MIN_VALUE).maximum(Integer.MAX_VALUE).actualValue(value).build().asImmutable();
            ImmutableValue oldAgeValue = this.getApiValueFromContainer(container).get().asImmutable();
            try {
                ((EntityAgeable)container).func_70873_a(value.intValue());
            }
            catch (Exception e) {
                return DataTransactionResult.errorResult(newAgeValue);
            }
            return builder.success(newAgeValue).replace(oldAgeValue).result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failResult(proposedValue);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

