/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.plugin;

import java.util.List;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.plugin.ListenerPhaseState;
import org.spongepowered.common.event.tracking.phase.plugin.ServerTickContext;

final class ServerTickPhaseState
extends ListenerPhaseState<ServerTickContext> {
    private final String desc;

    ServerTickPhaseState(String name) {
        this.desc = TrackingUtil.phaseStateToString("Plugin", name, this);
    }

    @Override
    public ServerTickContext createNewContext() {
        return (ServerTickContext)((ServerTickContext)new ServerTickContext(this).addCaptures()).player();
    }

    @Override
    public void unwind(ServerTickContext phaseContext) {
        Object listener = phaseContext.getSource(Object.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be capturing a ServerTickEvent listener!", phaseContext));
        TrackingUtil.processBlockCaptures(phaseContext);
        phaseContext.getBlockItemDropSupplier().acceptAndClearIfNotEmpty(map -> map.asMap().forEach((key, value) -> {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(listener);
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                List<Entity> items = value.stream().map(entity -> (Entity)entity).collect(Collectors.toList());
                SpongeCommonEventFactory.callDropItemDestruct(items, phaseContext);
            }
        }));
    }

    @Override
    public boolean doesDenyChunkRequests() {
        return true;
    }

    @Override
    public boolean doesBulkBlockCapture(ServerTickContext context) {
        return false;
    }

    @Override
    public boolean doesCaptureEntitySpawns() {
        return false;
    }

    @Override
    public boolean doesCaptureEntityDrops(ServerTickContext context) {
        return false;
    }

    @Override
    public String toString() {
        return this.desc;
    }
}

