/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.projectile;

import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.entity.projectile.Snowball;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.common.mixin.core.entity.projectile.EntityThrowableMixin;

@Mixin(value={EntitySnowball.class})
public abstract class EntitySnowballMixin
extends EntityThrowableMixin
implements Snowball {
    private double damageAmount = 0.0;
    private boolean damageSet = false;

    @ModifyArg(method={"onImpact"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    private float onAttackEntityFrom(float damage) {
        return this.damageSet ? (float)this.damageAmount : damage;
    }

    @Override
    public void spongeImpl$readFromSpongeCompound(NBTTagCompound compound) {
        super.spongeImpl$readFromSpongeCompound(compound);
        if (compound.func_74764_b("damageAmount")) {
            this.damageAmount = compound.func_74769_h("damageAmount");
            this.damageSet = true;
        }
    }

    @Override
    public void spongeImpl$writeToSpongeCompound(NBTTagCompound compound) {
        super.spongeImpl$writeToSpongeCompound(compound);
        if (this.damageSet) {
            compound.func_74780_a("damageAmount", this.damageAmount);
        } else {
            compound.func_82580_o("damageAmount");
        }
    }
}

