/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.profile.callback;

import com.google.common.base.Preconditions;
import com.mojang.authlib.ProfileLookupCallback;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.profile.GameProfile;

public final class MapProfileLookupCallback
implements ProfileLookupCallback {
    private final Map<String, Optional<GameProfile>> profiles;

    public MapProfileLookupCallback(Map<String, Optional<GameProfile>> profiles) {
        this.profiles = (Map)Preconditions.checkNotNull(profiles, (Object)"profiles");
    }

    public void onProfileLookupSucceeded(com.mojang.authlib.GameProfile profile) {
        this.profiles.put(profile.getName(), Optional.of((GameProfile)profile));
    }

    public void onProfileLookupFailed(com.mojang.authlib.GameProfile profile, Exception e) {
        this.profiles.put(profile.getName(), Optional.empty());
    }
}

