/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.forge.fluids;

import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.BlockFluidBase;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.bridge.block.BlockBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.mod.mixin.core.block.BlockMixin_Forge;

@Mixin(value={BlockFluidBase.class})
public abstract class BlockFluidBaseMixin_Forge
extends BlockMixin_Forge
implements BlockBridge {
    @Shadow(remap=false)
    @Final
    public static PropertyInteger LEVEL;
    @Shadow(remap=false)
    protected int tickRate;

    @Redirect(method={"canDisplace"}, remap=false, at=@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;", remap=false))
    private Object getDisplacementWithSponge(Map<?, ?> map, Object key, IBlockAccess world, BlockPos pos) {
        if (!ShouldFire.CHANGE_BLOCK_EVENT_PRE || ((WorldBridge)world).bridge$isFake()) {
            return map.get(key);
        }
        if (!((Boolean)map.get(key)).booleanValue()) {
            return Boolean.FALSE;
        }
        ChangeBlockEvent.Pre event = SpongeCommonEventFactory.callChangeBlockEventPre((WorldServerBridge)world, pos);
        if (event.isCancelled()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Inject(method={"canDisplace"}, cancellable=true, remap=false, locals=LocalCapture.CAPTURE_FAILSOFT, at={@At(value="INVOKE", target="Lnet/minecraftforge/fluids/BlockFluidBase;getDensity(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)I", remap=false)})
    private void onSpongeInjectFailEvent(IBlockAccess world, BlockPos pos, CallbackInfoReturnable<Boolean> cir, IBlockState state, Block block) {
        if (!ShouldFire.CHANGE_BLOCK_EVENT_PRE || ((WorldBridge)world).bridge$isFake()) {
            return;
        }
        ChangeBlockEvent.Pre event = SpongeCommonEventFactory.callChangeBlockEventPre((WorldServerBridge)world, pos);
        if (event.isCancelled()) {
            cir.setReturnValue(false);
        }
    }
}

