/*
 * Decompiled with CFR 0.152.
 */
package me.inamine.diceroller;

import java.util.ArrayList;
import java.util.List;
import me.inamine.diceroller.DRFileManager;
import me.inamine.diceroller.DRRoller;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class DRCommandExecutor
implements CommandExecutor {
    private final DRFileManager fileManager;
    private final Plugin plugin;
    private DRRoller roller;
    List<String> bCoolDown = new ArrayList<String>();
    List<String> pCoolDown = new ArrayList<String>();

    public DRCommandExecutor(DRFileManager fileManager, DRRoller roller, Plugin plugin) {
        this.fileManager = fileManager;
        this.plugin = plugin;
        this.roller = roller;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String commandName = command.getName();
        String prefix = this.fileManager.getMsg().getString("prefix", "&b&l[&eDiceRoller&b&l] ");
        if (commandName.equalsIgnoreCase("diceroller")) {
            if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
                if (!(sender instanceof Player) || sender.hasPermission("diceroller.reload")) {
                    this.plugin.reloadConfig();
                    this.fileManager.checkFiles();
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("reload-message").replace("%prefix%", prefix)));
                    return true;
                } else {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("no-permission").replace("%prefix%", prefix)));
                }
                return true;
            } else if (!(sender instanceof Player) || sender.hasPermission("diceroller.help")) {
                List usage = this.fileManager.getMsg().getStringList("help");
                for (String s : usage) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
                }
                return true;
            } else {
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("no-permission").replace("%prefix%", prefix)));
            }
            return true;
        }
        if (commandName.equalsIgnoreCase("roll")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("Console cannot run this command!");
                return true;
            }
            Player player = (Player)sender;
            if (player.hasPermission("diceroller.roll")) {
                if (args.length == 1 && args[0].equalsIgnoreCase("player") && !this.pCoolDown.contains(player.getUniqueId().toString())) {
                    if (player.hasPermission("diceroller.roll.player")) {
                        this.roller.rollPlayer(player, false);
                        return true;
                    } else {
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("no-permission").replace("%prefix%", prefix)));
                    }
                    return true;
                }
                if (args.length >= 1 && args[0].startsWith("c") && !this.pCoolDown.contains(player.getUniqueId().toString())) {
                    if (player.hasPermission("diceroller.roll.custom")) {
                        int rollID;
                        try {
                            rollID = Integer.parseInt(args[0].replaceFirst("c", ""));
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("invalid-number").replace("%prefix%", prefix)));
                            return true;
                        }
                        int rolls = 1;
                        if (args.length == 2) {
                            try {
                                rolls = Integer.parseInt(args[1]);
                            }
                            catch (NumberFormatException e) {
                                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("invalid-number").replace("%prefix%", prefix)));
                                return true;
                            }
                        }
                        this.roller.roll(player, rollID, true, false, rolls);
                        this.particles(player);
                        this.addCoolDown(player, false);
                        return true;
                    }
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("no-permission").replace("%prefix%", prefix)));
                    return false;
                }
                if (args.length >= 1 && args[0].startsWith("d") && !this.pCoolDown.contains(player.getUniqueId().toString())) {
                    int rollID;
                    try {
                        rollID = Integer.parseInt(args[0].replaceFirst("d", ""));
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("invalid-number").replace("%prefix%", prefix)));
                        return true;
                    }
                    if (this.plugin.getConfig().getIntegerList("accepted-rolls").contains(rollID)) {
                        int rolls = 1;
                        if (args.length == 2) {
                            try {
                                rolls = Integer.parseInt(args[1]);
                            }
                            catch (NumberFormatException e) {
                                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("invalid-number").replace("%prefix%", prefix)));
                                return true;
                            }
                        }
                        this.roller.roll(player, rollID, false, false, rolls);
                        this.particles(player);
                        this.addCoolDown(player, false);
                        return true;
                    }
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("invalid-roll").replace("%prefix%", prefix)));
                    return true;
                }
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("roll-usage").replace("%prefix%", prefix)));
                return true;
            }
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("no-permission").replace("%prefix%", prefix)));
            return true;
        }
        if (!commandName.equalsIgnoreCase("broll")) return false;
        if (!(sender instanceof Player)) {
            sender.sendMessage("Console cannot run this command!");
            return true;
        }
        Player player = (Player)sender;
        if (player.hasPermission("diceroller.broadcast")) {
            if (args.length == 1 && args[0].equalsIgnoreCase("player") && !this.pCoolDown.contains(player.getUniqueId().toString())) {
                if (player.hasPermission("diceroller.broadcast.player")) {
                    this.roller.rollPlayer(player, true);
                    return true;
                } else {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("no-permission").replace("%prefix%", prefix)));
                }
                return true;
            }
            if (args.length >= 1 && args[0].startsWith("c") && !this.pCoolDown.contains(player.getUniqueId().toString())) {
                if (player.hasPermission("diceroller.broadcast.custom")) {
                    int rollID;
                    try {
                        rollID = Integer.parseInt(args[0].replaceFirst("c", ""));
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("invalid-number").replace("%prefix%", prefix)));
                        return true;
                    }
                    int rolls = 1;
                    if (args.length == 2) {
                        try {
                            rolls = Integer.parseInt(args[1]);
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("invalid-number").replace("%prefix%", prefix)));
                            return true;
                        }
                    }
                    this.roller.roll(player, rollID, true, true, rolls);
                    this.particles(player);
                    this.addCoolDown(player, true);
                    return true;
                }
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("no-permission").replace("%prefix%", prefix)));
                return false;
            }
            if (args.length >= 1 && args[0].startsWith("d") && !this.pCoolDown.contains(player.getUniqueId().toString())) {
                int rollID;
                try {
                    rollID = Integer.parseInt(args[0].replaceFirst("d", ""));
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("invalid-number").replace("%prefix%", prefix)));
                    return true;
                }
                if (this.plugin.getConfig().getIntegerList("accepted-rolls").contains(rollID)) {
                    int rolls = 1;
                    if (args.length == 2) {
                        try {
                            rolls = Integer.parseInt(args[1]);
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("invalid-number").replace("%prefix%", prefix)));
                            return true;
                        }
                    }
                    this.roller.roll(player, rollID, false, true, rolls);
                    this.particles(player);
                    this.addCoolDown(player, false);
                    return true;
                }
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("invalid-roll").replace("%prefix%", prefix)));
                return true;
            }
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("broll-usage").replace("%prefix%", prefix)));
            return true;
        }
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.fileManager.getMsg().getString("no-permission").replace("%prefix%", prefix)));
        return true;
    }

    public void addCoolDown(Player player, boolean broadcast) {
        if (broadcast) {
            if (!player.hasPermission("diceroller.bypass.broadcast")) {
                this.bCoolDown.add(player.getUniqueId().toString());
                int delay = (int)this.plugin.getConfig().getDouble("broadcast-cooldown") * 20;
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(this.plugin, () -> this.bCoolDown.remove(player.getUniqueId().toString()), (long)delay);
            }
        } else if (!player.hasPermission("diceroller.bypass.roll")) {
            this.pCoolDown.add(player.getUniqueId().toString());
            int delay = (int)(this.plugin.getConfig().getDouble("personal-cooldown") * 20.0);
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(this.plugin, () -> this.pCoolDown.remove(player.getUniqueId().toString()), (long)delay);
        }
    }

    private void particles(Player player) {
        int count = this.plugin.getConfig().getInt("particle-count");
        if (Bukkit.getServer().getVersion().contains("1.7") || Bukkit.getServer().getVersion().contains("1.8")) {
            return;
        }
        try {
            Particle p = Particle.CRIT;
            Location location = player.getLocation();
            player.spawnParticle(p, location, count);
        }
        catch (Exception ignored) {
            return;
        }
    }
}

