/*
 * Decompiled with CFR 0.152.
 */
package me.inamine.diceroller;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import me.inamine.diceroller.DRCommandExecutor;
import me.inamine.diceroller.DRFileManager;
import me.inamine.diceroller.DRRoller;
import me.inamine.diceroller.DRTabCompleter;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;

public class DRCommandManager {
    private final Plugin plugin;
    private final DRCommandExecutor commandExecutor;
    private final DRTabCompleter tabCompleter;

    public DRCommandManager(Plugin plugin, DRFileManager fileManager) {
        this.plugin = plugin;
        this.commandExecutor = new DRCommandExecutor(fileManager, new DRRoller(fileManager, plugin.getConfig()), plugin);
        this.tabCompleter = new DRTabCompleter(plugin.getConfig());
    }

    private void registerCommand(String name, String description, String usage, String permission) {
        PluginCommand command = DRCommandManager.getCommand(name, this.plugin);
        command.setName(name);
        command.setDescription(description);
        command.setUsage(usage);
        command.setPermission(permission);
        command.setExecutor((CommandExecutor)this.commandExecutor);
        command.setTabCompleter((TabCompleter)this.tabCompleter);
        DRCommandManager.getCommandMap().register(this.plugin.getDescription().getName(), (Command)command);
    }

    private void registerCommand(String name, String description, String usage, String permission, String ... aliases) {
        PluginCommand command = DRCommandManager.getCommand(name, this.plugin);
        command.setName(name);
        command.setDescription(description);
        command.setUsage(usage);
        command.setPermission(permission);
        command.setAliases(Arrays.asList(aliases));
        command.setExecutor((CommandExecutor)this.commandExecutor);
        command.setTabCompleter((TabCompleter)this.tabCompleter);
        DRCommandManager.getCommandMap().register(this.plugin.getDescription().getName(), (Command)command);
    }

    private static PluginCommand getCommand(String name, Plugin plugin) {
        PluginCommand command = null;
        try {
            Constructor c = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            c.setAccessible(true);
            command = (PluginCommand)c.newInstance(name, plugin);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return command;
    }

    private static CommandMap getCommandMap() {
        CommandMap commandMap = null;
        try {
            if (Bukkit.getPluginManager() instanceof SimplePluginManager) {
                Field f = SimplePluginManager.class.getDeclaredField("commandMap");
                f.setAccessible(true);
                commandMap = (CommandMap)f.get(Bukkit.getPluginManager());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        return commandMap;
    }

    public void createAll() {
        String mainPermission = "diceroller.";
        String baseCommand = this.plugin.getConfig().getString("base-command", "diceroller");
        String baseDescription = "Dice Roller base command";
        String baseUsage = "/" + baseCommand + " [reload]";
        String basePermission = mainPermission + ".help";
        String[] aliases = this.plugin.getConfig().getStringList("aliases").toArray(new String[0]);
        this.registerCommand(baseCommand, baseDescription, baseUsage, basePermission, aliases);
        String rollCommand = "roll";
        String rollDescription = "Roll dice to yourself";
        String rollUsage = "/roll d<#>|player [quantity]";
        String rollPermission = mainPermission + "roll";
        this.registerCommand(rollCommand, rollDescription, rollUsage, rollPermission);
        String brollCommand = "broll";
        String brollDescription = "Roll dice to the server";
        String brollUsage = "/broll d<#>|player [quantity]";
        String brollPermission = mainPermission + "broadcast";
        this.registerCommand(brollCommand, brollDescription, brollUsage, brollPermission, "broadcastroll");
    }
}

