/*
 * Decompiled with CFR 0.152.
 */
package me.inamine.diceroller;

import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import me.inamine.diceroller.DRFileManager;
import me.inamine.diceroller.DRVentureChatLink;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class DRRoller {
    private final DRFileManager fileManager;
    private final FileConfiguration config;
    private final DRVentureChatLink chatLink;

    public DRRoller(DRFileManager fileManager, FileConfiguration config) {
        this.fileManager = fileManager;
        this.config = config;
        this.chatLink = new DRVentureChatLink(config);
    }

    public void rollPlayer(Player player, boolean broadcast) {
        ArrayList onlinePlayers = new ArrayList(Bukkit.getOnlinePlayers());
        int result = ThreadLocalRandom.current().nextInt(0, onlinePlayers.size());
        String resultName = ((Player)onlinePlayers.get(result)).getName();
        String message = this.fileManager.getMsg().getString("player-roll-result");
        if (message == null) {
            Bukkit.getLogger().warning("Invalid string for 'player-roll-result'");
            return;
        }
        String prefix = this.fileManager.getMsg().getString("prefix");
        if (prefix == null) {
            Bukkit.getLogger().warning("Invalid string for 'prefix'");
            return;
        }
        message = message.replace("%result%", resultName).replace("%prefix%", prefix).replace("%player%", player.getName());
        if (broadcast) {
            for (Player target : Bukkit.getOnlinePlayers()) {
                if (!target.hasPermission("diceroller.broadcast.view")) continue;
                target.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
            }
        } else {
            for (Player target : Bukkit.getOnlinePlayers()) {
                if (!target.hasPermission("diceroller.seeall")) continue;
                target.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
            }
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
    }

    public void roll(Player player, int faces, boolean custom, boolean broadcast, int rolls) {
        String prefix;
        String message;
        int result = ThreadLocalRandom.current().nextInt(1, faces + 1);
        int total = 0;
        StringBuilder results = new StringBuilder();
        if (rolls > 1) {
            int max;
            if (!player.hasPermission("diceroller.bypass.max") && rolls > (max = this.config.getInt("max-rolls"))) {
                rolls = max;
            }
            for (int i = 0; i < rolls; ++i) {
                int singleResult = ThreadLocalRandom.current().nextInt(1, faces + 1);
                total += singleResult;
                results.append(singleResult).append(",");
            }
            results = new StringBuilder(results.substring(0, results.length() - 1));
            message = custom ? this.fileManager.getMsg().getString("custom-roll-result-multi") : this.fileManager.getMsg().getString("roll-result-multi");
            if (message == null) {
                Bukkit.getLogger().warning("Invalid string for 'roll-result-multi' or 'custom-roll-result-multi'");
                return;
            }
        } else {
            message = custom ? this.fileManager.getMsg().getString("custom-roll-result") : this.fileManager.getMsg().getString("roll-result");
            if (message == null) {
                Bukkit.getLogger().warning("Invalid string for 'roll-result' or 'custom-roll-result'");
                return;
            }
        }
        if ((prefix = this.fileManager.getMsg().getString("prefix")) == null) {
            Bukkit.getLogger().warning("Invalid string for 'prefix'");
            return;
        }
        message = message.replace("%result%", String.valueOf(result)).replace("%sides%", String.valueOf(faces)).replace("%prefix%", prefix).replace("%player%", player.getName()).replace("%count%", String.valueOf(rolls)).replace("%results%", results.toString()).replace("%total%", String.valueOf(total));
        if (broadcast) {
            for (Player target : Bukkit.getOnlinePlayers()) {
                if (!target.hasPermission("diceroller.broadcast.view") || !this.chatLink.isListening(player, target)) continue;
                target.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
            }
        } else {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
    }
}

