/*
 * Decompiled with CFR 0.152.
 */
package me.inamine.diceroller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DRTabCompleter
implements TabCompleter {
    private final FileConfiguration config;

    public DRTabCompleter(FileConfiguration config) {
        this.config = config;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (command.getName().equalsIgnoreCase("diceroller")) {
            if (args.length == 1) {
                ArrayList<String> possibleCompletions = new ArrayList<String>();
                if (sender.hasPermission("diceroller.reload")) {
                    possibleCompletions.add("reload");
                }
                ArrayList<String> completions = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[0], possibleCompletions, completions);
                Collections.sort(completions);
                return completions;
            }
        } else if (command.getName().equalsIgnoreCase("roll") || command.getName().equalsIgnoreCase("broll")) {
            ArrayList<String> possibleCompletions = new ArrayList<String>();
            if (sender.hasPermission("diceroller.roll.player") || sender.hasPermission("diceroller.broadcast.player")) {
                possibleCompletions.add("player");
            }
            Object completions = this.config.getIntegerList("accepted-rolls").iterator();
            while (completions.hasNext()) {
                int roll = (Integer)completions.next();
                possibleCompletions.add("d" + roll);
            }
            completions = new ArrayList();
            StringUtil.copyPartialMatches((String)args[0], possibleCompletions, (Collection)completions);
            Collections.sort(completions);
            return completions;
        }
        return null;
    }
}

