/*
 * Decompiled with CFR 0.152.
 */
package me.inamine.diceroller;

import java.util.List;
import mineverse.Aust1n46.chat.api.MineverseChatAPI;
import mineverse.Aust1n46.chat.api.MineverseChatPlayer;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class DRVentureChatLink {
    private final FileConfiguration config;

    public DRVentureChatLink(FileConfiguration config) {
        this.config = config;
    }

    private String getTalking(Player player) {
        MineverseChatPlayer mcp = MineverseChatAPI.getOnlineMineverseChatPlayer((Player)player);
        return mcp.getCurrentChannel().getName();
    }

    private boolean isWhitelisted(String ch) {
        boolean useWhitelist = this.config.getBoolean("venturechat.use-whitelist");
        if (useWhitelist) {
            return true;
        }
        List whitelist = this.config.getStringList("venturechat.whitelist-channels");
        return whitelist.contains(ch);
    }

    public boolean isListening(Player sender, Player listener) {
        boolean usingVChat = this.config.getBoolean("venturechat.use");
        if (!usingVChat) {
            return true;
        }
        if (!Bukkit.getPluginManager().isPluginEnabled("VentureChat")) {
            return true;
        }
        String rolledCh = this.getTalking(sender);
        if (!this.isWhitelisted(rolledCh)) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("cannot-emote-vchat", "&cYou cannot use an Emote in this channel")));
            return false;
        }
        MineverseChatPlayer mcListener = MineverseChatAPI.getOnlineMineverseChatPlayer((Player)listener);
        MineverseChatPlayer mcSender = MineverseChatAPI.getOnlineMineverseChatPlayer((Player)sender);
        if (mcListener.isListening(rolledCh)) {
            double radius = mcSender.getCurrentChannel().getDistance();
            return listener.getLocation().distance(sender.getLocation()) <= radius;
        }
        return false;
    }
}

