/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.libs.ou.library;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;

public class DateTimeUtils {
    private LocalDate date;
    private LocalTime time;
    private final String dateFormat;
    private final String timeFormat;

    public DateTimeUtils(LocalDate date, LocalTime time, String dateFormat, String timeFormat) {
        this.date = date;
        this.time = time;
        this.timeFormat = timeFormat;
        this.dateFormat = dateFormat;
    }

    public DateTimeFormatter formatDateTime() {
        return DateTimeFormatter.ofPattern(this.dateFormat + " " + this.timeFormat);
    }

    public String getDateTime() {
        return LocalDateTime.of(this.date, this.time).format(this.formatDateTime());
    }

    public String getDate() {
        return LocalDate.of(this.date.getYear(), this.date.getMonth(), this.date.getDayOfMonth()).format(DateTimeFormatter.ofPattern(this.dateFormat));
    }

    public String getTime() {
        return LocalTime.of(this.time.getHour(), this.time.getMinute(), this.time.getSecond()).format(DateTimeFormatter.ofPattern(this.timeFormat));
    }

    public int getDayOfMonth() {
        return this.date.getDayOfMonth();
    }

    public String getMonth() {
        return this.date.getMonth().toString();
    }

    public int getMonthNumber() {
        return this.date.getMonthValue();
    }

    public int getLengthOfMonth() {
        return this.date.lengthOfMonth();
    }

    public void setTime(int hour, int minute, int second) {
        this.time = LocalTime.of(hour, minute, second);
    }

    public void setDate(int day, int month, int year) {
        this.date = LocalDate.of(year, month, day);
    }

    public LocalDate addDays(int daysToAdd) {
        return this.date.plusDays(daysToAdd);
    }

    public LocalDate addMonths(int monthsToAdd) {
        return this.date.plusMonths(monthsToAdd);
    }

    public LocalDate addYears(int yearsToAdd) {
        return this.date.plusYears(yearsToAdd);
    }

    public LocalDate addWeeks(int weeksToAdd) {
        return this.date.plusWeeks(weeksToAdd);
    }

    public LocalTime addHours(int hoursToAdd) {
        return this.time.plusHours(hoursToAdd);
    }

    public LocalTime addMinutes(int minutesToAdd) {
        return this.time.plusHours(minutesToAdd);
    }

    public LocalTime addSeconds(int secondsToAdd) {
        return this.time.plusHours(secondsToAdd);
    }

    public LocalDate takeDays(int daysToTake) {
        return this.date.minusDays(daysToTake);
    }

    public LocalDate takeMonths(int monthsToTake) {
        return this.date.minusMonths(monthsToTake);
    }

    public LocalDate takeYears(int yearsToTake) {
        return this.date.minusYears(yearsToTake);
    }

    public LocalDate takeWeeks(int weeksToTake) {
        return this.date.minusWeeks(weeksToTake);
    }

    public LocalTime takeHours(int hoursToTake) {
        return this.time.minusHours(hoursToTake);
    }

    public LocalTime takeMinutes(int minutesToTake) {
        return this.time.minusHours(minutesToTake);
    }

    public LocalTime takeSeconds(int secondsToTake) {
        return this.time.minusHours(secondsToTake);
    }

    public String getDayOfWeek() {
        String dayOfWeek;
        switch (this.date.getDayOfWeek().getValue()) {
            case 1: {
                dayOfWeek = "Monday";
                break;
            }
            case 2: {
                dayOfWeek = "Tuesday";
                break;
            }
            case 3: {
                dayOfWeek = "Wednesday";
                break;
            }
            case 4: {
                dayOfWeek = "Thursday";
                break;
            }
            case 5: {
                dayOfWeek = "Friday";
                break;
            }
            case 6: {
                dayOfWeek = "Saturday";
                break;
            }
            case 7: {
                dayOfWeek = "Sunday";
                break;
            }
            default: {
                dayOfWeek = "";
            }
        }
        return dayOfWeek;
    }

    public int getDayOfYear() {
        return this.date.getDayOfYear();
    }

    public int getYear() {
        return this.date.getYear();
    }

    public int getHour() {
        return this.time.getHour();
    }

    public int getMinute() {
        return this.time.getMinute();
    }

    public int getSecond() {
        return this.time.getSecond();
    }

    public String compareDate(LocalDate dateToCompare) {
        Period period = Period.between(this.date, dateToCompare);
        String comparedDate = period.getYears() + " Years, " + period.getMonths() + " Months, " + period.getDays() + " Days";
        return comparedDate.replace("-", "");
    }

    public String compareTime(LocalTime pastTime) {
        int hours1 = this.time.get(ChronoField.HOUR_OF_DAY);
        int hours2 = pastTime.get(ChronoField.HOUR_OF_DAY);
        int minute1 = this.time.get(ChronoField.MINUTE_OF_HOUR);
        int minute2 = pastTime.get(ChronoField.MINUTE_OF_HOUR);
        int seconds1 = this.time.get(ChronoField.SECOND_OF_MINUTE);
        int seconds2 = pastTime.get(ChronoField.SECOND_OF_MINUTE);
        String comparedTime = hours1 - hours2 + " Hours, " + (minute1 - minute2) + " Minutes, " + (seconds1 - seconds2) + " Seconds";
        return comparedTime.replace("-", "");
    }

    public static LocalDate convertLongToLocalDate(long dateToConvert) {
        return Instant.ofEpochMilli(dateToConvert).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalTime convertLongToLocalTime(long timeToConvert) {
        return Instant.ofEpochMilli(timeToConvert).atZone(ZoneId.systemDefault()).toLocalTime();
    }
}

