/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.libs.ou.library;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Utilities {
    private static JavaPlugin instance;
    private static final HashMap<String, CommandExecutor> commands;

    public static JavaPlugin getInstance() {
        return instance;
    }

    public static void setInstance(JavaPlugin instance) {
        Utilities.instance = instance;
    }

    public static String colourise(String message) {
        if (Bukkit.getBukkitVersion().contains("1.8.8")) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        }
        String serverVersionRaw = Bukkit.getBukkitVersion().substring(0, 4);
        double serverVersion = Double.parseDouble(serverVersionRaw);
        Pattern pattern = Pattern.compile("(#|&#)[a-fA-F0-9]{6}");
        if (serverVersion >= 1.16) {
            Matcher matcher = pattern.matcher(message);
            while (matcher.find()) {
                String colourise = message.substring(matcher.start(), matcher.end());
                message = message.replace(colourise, "" + net.md_5.bungee.api.ChatColor.of((String)colourise));
                matcher = pattern.matcher(message);
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static List<String> colourise(List<String> messages) {
        ArrayList<String> strings = new ArrayList<String>();
        for (String string : messages) {
            strings.add(Utilities.colourise(string));
        }
        return strings;
    }

    public static void message(CommandSender player, String message) {
        player.sendMessage(Utilities.colourise(message));
    }

    public static void message(CommandSender player, String ... messages) {
        for (String message : messages) {
            Utilities.message(player, message);
        }
    }

    public static void message(CommandSender player, List<String> messages) {
        for (String message : messages) {
            Utilities.message(player, message);
        }
    }

    public static void broadcast(boolean broadcastConsole, String message) {
        if (!broadcastConsole) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                Utilities.message((CommandSender)player, message);
            }
            return;
        }
        Bukkit.getServer().broadcastMessage(Utilities.colourise(message));
    }

    public static void broadcast(boolean broadcastConsole, String ... messages) {
        for (String message : messages) {
            Utilities.broadcast(broadcastConsole, message);
        }
    }

    public static void broadcast(boolean broadcastConsole, List<String> messages) {
        for (String message : messages) {
            Utilities.broadcast(broadcastConsole, message);
        }
    }

    public static boolean checkPermission(CommandSender player, boolean checkOp, String permission) {
        if (checkOp) {
            return player.hasPermission(permission) || player.isOp();
        }
        return player.hasPermission(permission);
    }

    public static boolean checkPermissions(CommandSender player, boolean checkOp, String ... permissions) {
        int n = 0;
        String[] stringArray = permissions;
        int n2 = stringArray.length;
        if (n < n2) {
            String permission = stringArray[n];
            return Utilities.checkPermission(player, checkOp, permission);
        }
        return false;
    }

    public static void logInfo(boolean prefix, String message) {
        if (prefix) {
            Bukkit.getLogger().info(Utilities.colourise("[" + Utilities.getInstance().getDescription().getName() + "] " + message));
        } else {
            Bukkit.getLogger().info(Utilities.colourise(message));
        }
    }

    public static void logInfo(boolean prefix, String ... messages) {
        for (String message : messages) {
            Utilities.logInfo(prefix, message);
        }
    }

    public static void logInfo(boolean prefix, List<String> messages) {
        for (String message : messages) {
            Utilities.logInfo(prefix, message);
        }
    }

    public static void logWarning(boolean prefix, String message) {
        if (prefix) {
            Bukkit.getLogger().warning(Utilities.colourise("[" + Utilities.getInstance().getDescription().getName() + "] " + message));
        } else {
            Bukkit.getLogger().warning(Utilities.colourise(message));
        }
    }

    public static void logWarning(boolean prefix, String ... messages) {
        for (String message : messages) {
            Utilities.logWarning(prefix, message);
        }
    }

    public static void logSevere(boolean prefix, String message) {
        if (prefix) {
            Bukkit.getLogger().severe(Utilities.colourise("[" + Utilities.getInstance().getDescription().getName() + "] " + message));
        }
        Bukkit.getLogger().severe(Utilities.colourise(message));
    }

    public static void logSevere(boolean prefix, String ... messages) {
        for (String message : messages) {
            Utilities.logSevere(prefix, message);
        }
    }

    public static void sendActionBar(Player player, String message) {
        try {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(Utilities.colourise(message)));
        }
        catch (Throwable throwable) {
            Utilities.message((CommandSender)player, message);
        }
    }

    public static void sendActionBar(Player player, String message, boolean sendMessage) {
        block2: {
            try {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(Utilities.colourise(message)));
            }
            catch (Throwable throwable) {
                if (!sendMessage) break block2;
                Utilities.message((CommandSender)player, message);
            }
        }
    }

    public static void sendTitle(Player player, String title, String subtitle) {
        player.sendTitle(Utilities.colourise(title), Utilities.colourise(subtitle), 20, 60, 10);
    }

    public static void sendTitle(Player player, String title, String subtitle, int fadein, int stay, int fadeout) {
        player.sendTitle(Utilities.colourise(title), Utilities.colourise(subtitle), 20 * fadein, 20 * stay, 20 * fadeout);
    }

    public static void addPotionEffect(Player player, PotionEffectType effect, int durationInSeconds, int amplifier) {
        player.addPotionEffect(new PotionEffect(effect, durationInSeconds * 20, amplifier));
    }

    public static void addPotionEffect(Player player, PotionEffectType effect, int durationInSeconds, int amplifier, boolean ambient, boolean particles, boolean icon) {
        player.addPotionEffect(new PotionEffect(effect, durationInSeconds * 20, amplifier, ambient, particles, icon));
    }

    public static void removePotionEffect(Player player, PotionEffectType effect) {
        player.removePotionEffect(effect);
    }

    public static boolean isPluginPresent(String plugin) {
        return Bukkit.getServer().getPluginManager().getPlugin(plugin) != null;
    }

    public static void registerCommand(String command, CommandExecutor commandExecutor) {
        Utilities.getInstance().getCommand(command).setExecutor(commandExecutor);
    }

    public static void registerMapCommand(Command command) {
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
            commandMap.register(command.getLabel(), command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerEvent(Listener listener) {
        Bukkit.getServer().getPluginManager().registerEvents(listener, (Plugin)Utilities.getInstance());
    }

    public static void registerCommands() {
        for (String s : commands.keySet()) {
            Utilities.getInstance().getCommand(s).setExecutor(commands.get(s));
        }
    }

    public static void registerMapCommands(Command ... commands) {
        for (Command command : commands) {
            Utilities.registerMapCommand(command);
        }
    }

    public static void registerEvents(Listener ... listeners) {
        for (Listener listener : listeners) {
            Utilities.registerEvent(listener);
        }
    }

    public static HashMap<String, CommandExecutor> setCommand() {
        return commands;
    }

    public static void executeConsoleCommand(String command) {
        Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), command);
    }

    static {
        commands = new HashMap();
    }
}

