/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.libs.ou.library.bossbars;

import java.util.Arrays;
import java.util.List;
import me.omegaweapondev.libs.ou.library.Utilities;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class AnimatedBossBar
extends BukkitRunnable {
    private final List<String> messages;
    private final Player player;
    private final BarColor color;
    private final BarStyle style;
    private final int time;

    public AnimatedBossBar(Player player, BarColor barColor, BarStyle barStyle, int displayTime, String ... messages) {
        this.player = player;
        this.time = displayTime;
        this.messages = Arrays.asList(messages);
        this.color = BarColor.valueOf((String)String.valueOf(barColor));
        this.style = BarStyle.valueOf((String)String.valueOf(barStyle));
    }

    public void run() {
        BossBar bar = null;
        boolean created = false;
        for (String message : this.messages) {
            if (!created) {
                bar = Bukkit.createBossBar((String)Utilities.colourise(message), (BarColor)this.color, (BarStyle)this.style, (BarFlag[])new BarFlag[0]);
                bar.addPlayer(this.player);
                bar.setVisible(true);
                created = true;
            } else {
                bar.setTitle(Utilities.colourise(message));
            }
            try {
                Thread.sleep((long)this.time * 1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (created) {
            bar.removeAll();
            bar.setVisible(false);
        }
    }
}

