/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.libs.ou.library.builders;

import java.util.ArrayList;
import java.util.List;
import me.omegaweapondev.libs.ou.library.Utilities;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class BookBuilder {
    private final ItemStack itemStack;
    private final BookMeta bookMeta;
    private final List<String> pages = new ArrayList<String>();

    protected BookBuilder(Material material) {
        this.itemStack = new ItemStack(material);
        this.bookMeta = (BookMeta)this.itemStack.getItemMeta();
    }

    public void setTitle(String title) {
        this.bookMeta.setTitle(Utilities.colourise(title));
    }

    public void setAuthor(String author) {
        this.bookMeta.setAuthor(Utilities.colourise(author));
    }

    public void addPage(String ... textList) {
        StringBuilder list = new StringBuilder();
        int count = 0;
        for (String text : textList) {
            if (count != textList.length - 1) {
                ++count;
                list.append(text).append("\n");
                continue;
            }
            list.append(text);
        }
        this.pages.add(list.toString());
    }

    public void setPages() {
        this.bookMeta.setPages(Utilities.colourise(this.pages));
    }

    public void setGenerationType(BookMeta.Generation type) {
        this.bookMeta.setGeneration(type);
    }

    public ItemStack getItem() {
        this.itemStack.setItemMeta((ItemMeta)this.bookMeta);
        return this.itemStack;
    }

    public BookMeta getBookMeta() {
        return this.bookMeta;
    }
}

