/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.libs.ou.library.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.omegaweapondev.libs.ou.library.Utilities;
import me.omegaweapondev.libs.skullcreator.skullcreator.SkullCreator;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class HeadBuilder {
    private final ItemStack itemStack;
    private final SkullMeta skullMeta;
    private final ArrayList<String> lore = new ArrayList();

    public HeadBuilder(UUID uuid) {
        this.itemStack = SkullCreator.itemFromUuid((UUID)uuid);
        this.skullMeta = (SkullMeta)this.itemStack.getItemMeta();
    }

    public HeadBuilder(String url) {
        this.itemStack = SkullCreator.itemFromUrl((String)url);
        this.skullMeta = (SkullMeta)this.itemStack.getItemMeta();
    }

    public HeadBuilder(Object string) {
        this.itemStack = SkullCreator.itemFromBase64((String)string.toString());
        this.skullMeta = (SkullMeta)this.itemStack.getItemMeta();
    }

    public void setDisplayName(String name) {
        this.skullMeta.setDisplayName(Utilities.colourise(name));
    }

    public void setLore(String ... loreList) {
        for (String list : loreList) {
            this.lore.add(Utilities.colourise("&r" + list));
        }
        this.skullMeta.setLore(this.lore);
    }

    public void setLore(List<String> loreList) {
        for (String list : loreList) {
            this.lore.add(Utilities.colourise("&r" + list));
        }
        this.skullMeta.setLore(this.lore);
    }

    public void addEnchantment(Enchantment enchantment, int level, boolean ignoreRestrictions) {
        this.skullMeta.addEnchant(enchantment, level, ignoreRestrictions);
    }

    public void setItemFlags(ItemFlag ... flags) {
        this.skullMeta.addItemFlags(flags);
    }

    public void setGlowing() {
        this.addEnchantment(Enchantment.ARROW_INFINITE, 0, true);
        this.setItemFlags(ItemFlag.HIDE_ENCHANTS);
    }

    public ItemStack create() {
        this.itemStack.setItemMeta((ItemMeta)this.skullMeta);
        return this.itemStack;
    }
}

