/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.libs.ou.library.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.omegaweapondev.libs.ou.library.Utilities;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBuilder {
    private final ItemStack itemStack;
    private final ItemMeta itemMeta;
    private final ArrayList<String> lore = new ArrayList();

    public ItemBuilder(Material material) {
        this.itemStack = new ItemStack(material == null ? Material.BARRIER : material);
        this.itemMeta = this.itemStack.getItemMeta();
    }

    public void setDisplayName(String name) {
        this.itemMeta.setDisplayName(Utilities.colourise(name));
    }

    public void setLore(String ... loreList) {
        for (String list : loreList) {
            this.lore.add(Utilities.colourise("&r" + list));
        }
        this.itemMeta.setLore(this.lore);
    }

    public void setLore(List<String> loreList) {
        for (String list : loreList) {
            this.lore.add(Utilities.colourise("&r" + list));
        }
        this.itemMeta.setLore(this.lore);
    }

    public void addEnchantment(Enchantment enchantment, int level, boolean ignoreRestrictions) {
        this.itemMeta.addEnchant(enchantment, level, ignoreRestrictions);
    }

    public void setItemFlags(ItemFlag ... flags) {
        this.itemMeta.addItemFlags(flags);
    }

    public void setUnbreakable() {
        this.itemMeta.setUnbreakable(true);
    }

    public void setGlowing() {
        this.addEnchantment(Enchantment.ARROW_INFINITE, 0, true);
        this.setItemFlags(ItemFlag.HIDE_ENCHANTS);
    }

    public ItemStack checkInvalidMaterial(String material, String name, List<String> lore) {
        if (Material.getMaterial((String)material.toUpperCase()) == null) {
            this.setDisplayName(Utilities.colourise("#FF4A4AInvalid Material"));
            this.setLore(Utilities.colourise(Arrays.asList("#FF4A4AThis item is invalid", "#FF4A4APlease pick another material to use", "#FF4A4Athat is supported by your server version")));
            return this.getItem();
        }
        this.setDisplayName(Utilities.colourise(name));
        this.setLore(Utilities.colourise(lore));
        return this.getItem();
    }

    public ItemStack getItem() {
        this.itemStack.setItemMeta(this.itemMeta);
        return this.itemStack;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public ItemMeta getItemMeta() {
        return this.itemMeta;
    }
}

