/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.libs.ou.library.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.omegaweapondev.libs.ou.library.Utilities;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class TabCompleteBuilder {
    private final ArrayList<String> commandList = new ArrayList();
    private final CommandSender commandSender;

    public TabCompleteBuilder(CommandSender commandSender) {
        this.commandSender = commandSender;
    }

    public TabCompleteBuilder checkCommand(String command, boolean checkOp, String ... permission) {
        if (!Utilities.checkPermissions(this.commandSender, checkOp, permission)) {
            return this;
        }
        this.commandList.add(command);
        return this;
    }

    public TabCompleteBuilder checkCommand(List<String> commands, boolean checkOp, String ... permission) {
        if (!Utilities.checkPermissions(this.commandSender, checkOp, permission)) {
            return this;
        }
        this.commandList.addAll(commands);
        return this;
    }

    public TabCompleteBuilder checkCommand(String command, boolean checkOp, String permission) {
        if (!Utilities.checkPermission(this.commandSender, checkOp, permission)) {
            return this;
        }
        this.commandList.add(command);
        return this;
    }

    public TabCompleteBuilder checkCommand(List<String> commands, boolean checkOp, String permission) {
        if (!Utilities.checkPermission(this.commandSender, checkOp, permission)) {
            return this;
        }
        this.commandList.addAll(commands);
        return this;
    }

    public TabCompleteBuilder addCommand(String command) {
        this.commandList.add(command);
        return this;
    }

    public TabCompleteBuilder addCommand(List<String> commands) {
        this.commandList.addAll(commands);
        return this;
    }

    public List<String> build(String args) {
        return ((ArrayList)StringUtil.copyPartialMatches((String)args, this.commandList, new ArrayList())).stream().sorted().collect(Collectors.toList());
    }
}

