/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.libs.ou.library.chat;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import me.omegaweapondev.libs.ou.library.Utilities;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.entity.Player;

public class ChatComponent {
    private BaseComponent current;
    private final List<BaseComponent> parts = new ArrayList<BaseComponent>();

    public ChatComponent(ChatComponent original) {
        this.current = original.current.duplicate();
        for (BaseComponent baseComponent : original.parts) {
            this.parts.add(baseComponent.duplicate());
        }
    }

    public ChatComponent(String text) {
        this.current = new TextComponent(TextComponent.fromLegacyText((String)Utilities.colourise(text)));
    }

    public ChatComponent(BaseComponent component) {
        this.current = component.duplicate();
    }

    public ChatComponent append(BaseComponent component) {
        return this.append(component, ComponentBuilder.FormatRetention.ALL);
    }

    public ChatComponent append(BaseComponent component, ComponentBuilder.FormatRetention retention) {
        this.parts.add(this.current);
        BaseComponent previous = this.current;
        this.current = component.duplicate();
        this.current.copyFormatting(previous, retention, false);
        return this;
    }

    public ChatComponent append(BaseComponent[] components) {
        return this.append(components, ComponentBuilder.FormatRetention.ALL);
    }

    public ChatComponent append(BaseComponent[] components, ComponentBuilder.FormatRetention retention) {
        Preconditions.checkArgument((components.length != 0 ? 1 : 0) != 0, (Object)"No components to append");
        BaseComponent previous = this.current;
        for (BaseComponent component : components) {
            this.parts.add(this.current);
            this.current = component.duplicate();
            this.current.copyFormatting(previous, retention, false);
        }
        return this;
    }

    public ChatComponent append(String text) {
        return this.append(text, ComponentBuilder.FormatRetention.FORMATTING);
    }

    public ChatComponent append(String text, ComponentBuilder.FormatRetention retention) {
        this.parts.add(this.current);
        BaseComponent old = this.current;
        this.current = new TextComponent(TextComponent.fromLegacyText((String)Utilities.colourise(text)));
        this.current.copyFormatting(old, retention, false);
        return this;
    }

    public ChatComponent appendNewLine() {
        return this.append("\n");
    }

    public ChatComponent appendHover(String hoverText) {
        return this.onHover(hoverText);
    }

    public ChatComponent appendHover(String displayText, String hoverText) {
        return this.append(displayText).onHover(hoverText);
    }

    public ChatComponent appendHover(String displayText, String ... textList) {
        StringBuilder list = new StringBuilder();
        int count = 0;
        for (String text : textList) {
            if (count != textList.length - 1) {
                ++count;
                list.append(text).append("&r\n");
                continue;
            }
            list.append(text);
        }
        return this.appendHover(displayText, list.toString());
    }

    public ChatComponent appendClickCommand(String displayText, String commandText) {
        return this.append(displayText).onClickRunCmd(commandText);
    }

    public ChatComponent appendSuggestCommand(String displayText, String commandText) {
        return this.append(displayText).onClickSuggestCmd(commandText);
    }

    public ChatComponent onClickRunCmd(String text) {
        return this.onClick(ClickEvent.Action.RUN_COMMAND, text);
    }

    public ChatComponent onClickSuggestCmd(String text) {
        return this.onClick(ClickEvent.Action.SUGGEST_COMMAND, text);
    }

    public ChatComponent onClick(ClickEvent.Action action, String text) {
        this.current.setClickEvent(new ClickEvent(action, Utilities.colourise(text)));
        return this;
    }

    public ChatComponent onHover(String text) {
        return this.onHover(HoverEvent.Action.SHOW_TEXT, text);
    }

    public ChatComponent onHover(HoverEvent.Action action, String text) {
        this.current.setHoverEvent(new HoverEvent(action, new Content[]{new Text(Utilities.colourise(text))}));
        return this;
    }

    public ChatComponent retain(ComponentBuilder.FormatRetention retention) {
        this.current.retain(retention);
        return this;
    }

    public BaseComponent[] create() {
        BaseComponent[] result = this.parts.toArray(new BaseComponent[this.parts.size() + 1]);
        result[this.parts.size()] = this.current;
        return result;
    }

    public void send(Player ... players) {
        BaseComponent[] comp = this.create();
        for (Player player : players) {
            player.spigot().sendMessage(comp);
        }
    }

    public static ChatComponent builder(String text) {
        return new ChatComponent(text);
    }
}

