/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.libs.ou.library.menus;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.omegaweapondev.libs.ou.library.Utilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class MenuCreator {
    public static Map<UUID, MenuCreator> inventoriesByUUID = new HashMap<UUID, MenuCreator>();
    public static Map<UUID, UUID> openInventories = new HashMap<UUID, UUID>();
    private final UUID uuid = UUID.randomUUID();
    private final Inventory inventoryCreator;
    private final Map<Integer, inventoryAction> actions;

    public MenuCreator(int inventoryRows, String inventoryName, String defaultInventoryName) {
        this.inventoryCreator = Bukkit.createInventory(null, (int)(inventoryRows * 9), (String)Utilities.colourise(inventoryName != null ? inventoryName : defaultInventoryName));
        this.actions = new HashMap<Integer, inventoryAction>();
        inventoriesByUUID.put(this.getUuid(), this);
    }

    public void setItem(int slot, ItemStack stack, inventoryAction action) {
        this.inventoryCreator.setItem(slot, stack);
        if (action != null) {
            this.actions.put(slot, action);
        }
    }

    public void setItem(int slot, ItemStack stack) {
        this.setItem(slot, stack, null);
    }

    public void openInventory(Player player) {
        player.openInventory(this.inventoryCreator);
        openInventories.put(player.getUniqueId(), this.getUuid());
    }

    public void deleteInventory() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            UUID uuid = openInventories.get(player.getUniqueId());
            if (!uuid.equals(this.getUuid())) continue;
            player.closeInventory();
        }
        inventoriesByUUID.remove(this.getUuid());
    }

    public Inventory getInventoryCreator() {
        return this.inventoryCreator;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public static Map<UUID, MenuCreator> getInventoriesByUUID() {
        return inventoriesByUUID;
    }

    public static Map<UUID, UUID> getOpenInventories() {
        return openInventories;
    }

    public Map<Integer, inventoryAction> getActions() {
        return this.actions;
    }

    public static interface inventoryAction {
        public void click(Player var1);
    }
}

