/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.stylizer;

import me.omegaweapondev.libs.bstats.bukkit.Metrics;
import me.omegaweapondev.libs.ou.library.SpigotUpdater;
import me.omegaweapondev.libs.ou.library.Utilities;
import me.omegaweapondev.libs.ou.library.menus.MenuCreator;
import me.omegaweapondev.stylizer.commands.ChatColour;
import me.omegaweapondev.stylizer.commands.ClearLog;
import me.omegaweapondev.stylizer.commands.DebugCommand;
import me.omegaweapondev.stylizer.commands.ItemNamer;
import me.omegaweapondev.stylizer.commands.MainCommand;
import me.omegaweapondev.stylizer.commands.NameColour;
import me.omegaweapondev.stylizer.events.ChatListener;
import me.omegaweapondev.stylizer.events.MenuListener;
import me.omegaweapondev.stylizer.events.PlayerListener;
import me.omegaweapondev.stylizer.events.ServerPingListener;
import me.omegaweapondev.stylizer.menus.ChatColours;
import me.omegaweapondev.stylizer.menus.NameColours;
import me.omegaweapondev.stylizer.utilities.Placeholders;
import me.omegaweapondev.stylizer.utilities.SettingsHandler;
import net.milkbowl.vault.chat.Chat;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Stylizer
extends JavaPlugin {
    private Stylizer plugin;
    private NameColours nameColourGUI;
    private ChatColours chatColourGUI;
    private SettingsHandler settingsHandler;
    private static Chat chat = null;

    public void onEnable() {
        this.plugin = this;
        this.settingsHandler = new SettingsHandler(this.plugin);
        Utilities.logInfo(false, " _____ _         _ _", "/  ___| |       | (_) ", "\\ `--.| |_ _   _| |_ _______ _ __ ", " `--. \\ __| | | | | |_  / _ \\ '__| Stylizer v" + this.plugin.getDescription().getVersion() + " By OmegaWeaponDev", "/\\__/ / |_| |_| | | |/ /  __/ | Running on version: " + Bukkit.getVersion(), "\\____/ \\__|\\__, |_|_/___\\___|_|", "            __/ |", "           |___/ ");
        this.initialSetup();
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            Utilities.logSevere(true, "Stylizer has detected that you do not have vault installed.", "A majority of Stylizers features rely on Vault for them to work correctly.", "So it is required that you install vault otherwise these features won't work.", "You can install vault here: https://www.spigotmc.org/resources/vault.34315/");
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
            return;
        }
        this.setupChat();
        this.getSettingsHandler().setupConfigs();
        this.getSettingsHandler().configUpdater();
        this.commandSetup();
        this.eventsSetup();
        this.guiSetup();
        this.spigotUpdater();
    }

    public void onDisable() {
        if (!MenuCreator.getOpenInventories().isEmpty()) {
            this.nameColourGUI.deleteInventory();
            this.chatColourGUI.deleteInventory();
        }
        super.onDisable();
    }

    public void onReload() {
        this.getSettingsHandler().reloadFiles();
    }

    private void initialSetup() {
        Utilities.setInstance(this);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new Placeholders(this).register();
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") == null) {
            Utilities.logWarning(true, "Stylizer requires PlaceholderAPI to be installed if you are wanting to use the `%stylizer_namecolour%` placeholder", "It is also required if you are wanting to use placeholders in any of the chat formats.", "You can install PlaceholderAPI here: https://www.spigotmc.org/resources/placeholderapi.6245/ ");
        }
        int bstatsPluginId = 7490;
        Metrics metrics = new Metrics(this.plugin, 7490);
    }

    private void guiSetup() {
        this.nameColourGUI = new NameColours(this.plugin);
        this.chatColourGUI = new ChatColours(this.plugin);
    }

    private void commandSetup() {
        Utilities.logInfo(true, "Registering the commands...");
        Utilities.setCommand().put("stylizer", new MainCommand(this.plugin));
        Utilities.setCommand().put("namecolour", new NameColour(this.plugin));
        Utilities.setCommand().put("stylizerdebug", new DebugCommand(this.plugin));
        Utilities.setCommand().put("itemnamer", new ItemNamer(this.plugin));
        Utilities.setCommand().put("stylizerclearlog", new ClearLog(this.plugin));
        Utilities.setCommand().put("chatcolour", new ChatColour(this.plugin));
        Utilities.registerCommands();
        Utilities.logInfo(true, "Commands Registered: " + Utilities.setCommand().size() + " / 6");
    }

    private void eventsSetup() {
        Utilities.registerEvents(new PlayerListener(this.plugin), new MenuListener(), new ChatListener(this.plugin), new ServerPingListener(this.plugin));
    }

    private void spigotUpdater() {
        if (!this.getSettingsHandler().getConfigFile().getConfig().getBoolean("Update_Messages")) {
            return;
        }
        new SpigotUpdater((Plugin)this.plugin, 78327).getVersion(version -> {
            int spigotVersion = Integer.parseInt(version.replace(".", ""));
            int pluginVersion = Integer.parseInt(this.plugin.getDescription().getVersion().replace(".", ""));
            if (pluginVersion >= spigotVersion) {
                Utilities.logInfo(true, "You are already running the latest version");
                return;
            }
            PluginDescriptionFile pdf = this.plugin.getDescription();
            Utilities.logWarning(true, "A new version of " + pdf.getName() + " is avaliable!", "Current Version: " + pdf.getVersion() + " > New Version: " + version, "Grab it here: https://www.spigotmc.org/resources/stylizer.78327/");
        });
    }

    private boolean setupChat() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Chat.class);
        chat = (Chat)rsp.getProvider();
        return chat != null;
    }

    public NameColours getNameColourGUI() {
        return this.nameColourGUI;
    }

    public ChatColours getChatColourGUI() {
        return this.chatColourGUI;
    }

    public Chat getChat() {
        return chat;
    }

    public SettingsHandler getSettingsHandler() {
        return this.settingsHandler;
    }
}

