/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.stylizer.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.omegaweapondev.libs.ou.library.Utilities;
import me.omegaweapondev.libs.ou.library.builders.TabCompleteBuilder;
import me.omegaweapondev.libs.ou.library.commands.GlobalCommand;
import me.omegaweapondev.stylizer.Stylizer;
import me.omegaweapondev.stylizer.utilities.MessageHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ChatColour
extends GlobalCommand
implements TabCompleter {
    private final Stylizer plugin;
    private final MessageHandler messageHandler;
    private final FileConfiguration configFile;
    private final FileConfiguration playerData;

    public ChatColour(Stylizer plugin) {
        this.plugin = plugin;
        this.messageHandler = new MessageHandler(plugin, plugin.getSettingsHandler().getMessagesFile().getConfig());
        this.configFile = plugin.getSettingsHandler().getConfigFile().getConfig();
        this.playerData = plugin.getSettingsHandler().getPlayerData().getConfig();
    }

    @Override
    protected void execute(CommandSender commandSender, String[] strings) {
        if (commandSender instanceof Player) {
            Player player = ((Player)commandSender).getPlayer();
            if (strings.length == 0) {
                this.openChatColourGUI(player);
                return;
            }
            if (strings.length == 2) {
                this.removeChatColour(player, strings);
                return;
            }
            if (strings.length == 3) {
                this.addChatColour(player, strings);
                return;
            }
        }
        if (strings.length == 0) {
            Utilities.logInfo(true, "You must be a player to open the ChatColour GUI");
            return;
        }
        if (strings.length == 2 && strings[0].equalsIgnoreCase("remove")) {
            this.removeChatColour(null, strings);
            return;
        }
        if (strings.length == 3) {
            this.addChatColour(null, strings);
        }
    }

    private void openChatColourGUI(Player player) {
        if (!Utilities.checkPermissions((CommandSender)player, true, "stylizer.chatcolour.open", "stylizer.admin")) {
            Utilities.message((CommandSender)player, this.messageHandler.string("No_Permission", "&cSorry, you do not have permission to do that."));
            return;
        }
        this.plugin.getChatColourGUI().openInventory(player);
    }

    private void addChatColour(Player player, String[] strings) {
        Player target = Bukkit.getPlayer((String)strings[1]);
        String chatColour = strings[2];
        if (!strings[0].equalsIgnoreCase("add")) {
            return;
        }
        if (player != null && !Utilities.checkPermissions((CommandSender)player, true, "stylizer.chatcolour.add", "stylizer.admin")) {
            Utilities.message((CommandSender)player, this.messageHandler.string("No_Permission", "&cSorry, you do not have permission to do that."));
            return;
        }
        if (target == null) {
            if (player != null) {
                Utilities.message((CommandSender)player, this.messageHandler.string("Invalid_Player", "&cSorry, that player cannot be found."));
                return;
            }
            Utilities.logInfo(true, "Sorry, that player cannot be found.");
            return;
        }
        if (chatColour.equalsIgnoreCase("")) {
            this.removeChatColour(player, strings);
            return;
        }
        this.playerData.set(target.getUniqueId().toString() + ".Chat_Colour", (Object)chatColour);
        this.plugin.getSettingsHandler().getPlayerData().saveConfig();
        Utilities.message((CommandSender)target, this.messageHandler.string("Chat_Colour_Applied", "&bYour chat colour has been changed to: %chatcolour%").replace("%chatcolour%", chatColour + player.getName()));
    }

    private void removeChatColour(Player player, String[] strings) {
        Player target = Bukkit.getPlayer((String)strings[1]);
        if (!strings[0].equalsIgnoreCase("remove")) {
            return;
        }
        if (player != null && !Utilities.checkPermissions((CommandSender)player, true, "stylizer.chatcolour.remove", "stylizer.admin")) {
            Utilities.message((CommandSender)player, this.messageHandler.string("No_Permission", "&cSorry, you do not have permission to do that."));
            return;
        }
        if (target == null) {
            if (player != null) {
                Utilities.message((CommandSender)player, this.messageHandler.string("Invalid_Player", "&cSorry, that player cannot be found."));
                return;
            }
            Utilities.logInfo(true, "Sorry, that player cannot be found.");
            return;
        }
        for (String groupName : this.configFile.getConfigurationSection("Group_Chat_Colour.Groups").getKeys(false)) {
            if (Utilities.checkPermission((CommandSender)target, false, "stylizer.chatcolour.groups." + groupName)) {
                this.playerData.set(target.getUniqueId() + ".Chat_Colour", (Object)this.plugin.getSettingsHandler().getConfigFile().getConfig().getString("Group_Chat_Colour.Groups." + groupName));
                this.plugin.getSettingsHandler().getPlayerData().saveConfig();
                Utilities.message((CommandSender)target, this.messageHandler.string("Chat_Colour_Removed", "&cYour chat colour has been reverted to the default colour"));
                return;
            }
            this.playerData.set(target.getUniqueId() + ".Chat_Colour", (Object)this.configFile.getString("Default_Chat_Colour", "&e"));
            this.plugin.getSettingsHandler().getPlayerData().saveConfig();
            Utilities.message((CommandSender)target, this.messageHandler.string("Chat_Colour_Removed", "&cYour chat colour has been reverted to the default colour"));
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, String[] strings) {
        if (strings.length <= 1) {
            return new TabCompleteBuilder(commandSender).checkCommand("add", true, "stylizer.chatcolour.add", "stylizer.admin").checkCommand("remove", true, "stylizer.chatcolour.remove", "stylizer.admin").build(strings[0]);
        }
        if (strings.length <= 2 && strings[0].equalsIgnoreCase("add")) {
            ArrayList<String> players = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                players.add(player.getName());
            }
            return new TabCompleteBuilder(commandSender).addCommand(players).build(strings[1]);
        }
        if (strings.length == 2 && strings[0].equalsIgnoreCase("remove")) {
            ArrayList<String> players = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                players.add(player.getName());
            }
            return new TabCompleteBuilder(commandSender).addCommand(players).build(strings[1]);
        }
        if (strings.length == 3 && strings[0].equalsIgnoreCase("add")) {
            ArrayList<String> colours = new ArrayList<String>();
            for (ChatColor color : ChatColor.values()) {
                colours.add(color.toString().replaceAll("\u00a7", "&"));
            }
            return new TabCompleteBuilder(commandSender).addCommand(colours).build(strings[2]);
        }
        return Collections.emptyList();
    }
}

