/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.stylizer.commands;

import java.util.Collections;
import java.util.List;
import me.omegaweapondev.libs.ou.library.Utilities;
import me.omegaweapondev.libs.ou.library.commands.GlobalCommand;
import me.omegaweapondev.stylizer.Stylizer;
import me.omegaweapondev.stylizer.utilities.MessageHandler;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ClearLog
extends GlobalCommand
implements TabCompleter {
    private final Stylizer plugin;
    private final MessageHandler messageHandler;
    private final FileConfiguration chatLog;

    public ClearLog(Stylizer plugin) {
        this.plugin = plugin;
        this.messageHandler = new MessageHandler(plugin, plugin.getSettingsHandler().getMessagesFile().getConfig());
        this.chatLog = plugin.getSettingsHandler().getChatLog().getConfig();
    }

    @Override
    protected void execute(CommandSender commandSender, String[] strings) {
        if (!(commandSender instanceof Player)) {
            this.chatLog.set("Chat_Log", null);
            this.plugin.getSettingsHandler().getChatLog().saveConfig();
            return;
        }
        Player player = (Player)commandSender;
        if (!Utilities.checkPermissions((CommandSender)player, true, "stylizer.clearlog", "stylizer.admin")) {
            Utilities.message((CommandSender)player, this.messageHandler.string("No_Permission", "#570000I'm sorry, but you do not have permission to do that!"));
            return;
        }
        this.chatLog.set("Chat_Log", null);
        this.plugin.getSettingsHandler().getChatLog().saveConfig();
        Utilities.message((CommandSender)player, this.messageHandler.string("Clear_Chat_Log", "#14abc9You have cleared the chat log."));
    }

    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, String[] strings) {
        return Collections.emptyList();
    }
}

