/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.stylizer.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.omegaweapondev.libs.ou.library.Utilities;
import me.omegaweapondev.libs.ou.library.builders.TabCompleteBuilder;
import me.omegaweapondev.libs.ou.library.commands.PlayerCommand;
import me.omegaweapondev.stylizer.Stylizer;
import me.omegaweapondev.stylizer.utilities.MessageHandler;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ItemNamer
extends PlayerCommand
implements TabCompleter {
    private final Stylizer plugin;
    private final MessageHandler messageHandler;
    private final FileConfiguration configFile;

    public ItemNamer(Stylizer plugin) {
        this.plugin = plugin;
        this.messageHandler = new MessageHandler(plugin, plugin.getSettingsHandler().getMessagesFile().getConfig());
        this.configFile = plugin.getSettingsHandler().getConfigFile().getConfig();
    }

    @Override
    protected void execute(Player player, String[] strings) {
        if (!Utilities.checkPermissions((CommandSender)player, true, "stylizer.itemnamer.use", "stylizer.admin")) {
            Utilities.message((CommandSender)player, this.messageHandler.string("No_Permission", "#570000I'm sorry, but you do not have permission to do that"));
            return;
        }
        if (strings.length < 2) {
            this.invalidArgs(player);
            return;
        }
        String[] values = Arrays.copyOfRange(strings, 2, strings.length);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : values) {
            stringBuilder.append(string).append(" ");
        }
        ArrayList<String> loreMessages = new ArrayList<String>();
        Collections.addAll(loreMessages, stringBuilder.toString().split("\\|"));
        String action = strings[0];
        String type = strings[1];
        String value = stringBuilder.toString();
        this.updateItemName(player, action, type, value, loreMessages);
    }

    private void invalidArgs(Player player) {
        Utilities.message((CommandSender)player, "#14abc9===========================================", "#ff4a4aItemNamer Help", "#14abc9===========================================", "#14abc9Set Item Name: #ff4a4a/itemnamer set name <Item Name>", "#14abc9Set Item Lore: #ff4a4a/itemnamer set lore <Item Lore>", "#14abc9Remove Item Name: #ff4a4a/itemnamer remove name", "#14abc9Remove Item Lore: #ff4a4a/itemnamer remove lore", "#14abc9===========================================");
    }

    private void updateItemName(Player player, String action, String type, String value, List<String> lore) {
        if (player.getInventory().getItemInMainHand().getType() == Material.AIR) {
            Utilities.message((CommandSender)player, this.messageHandler.getPrefix() + "#ff4a4aPlease equip the item you are wanting to update.");
            return;
        }
        if (type.equals("lore")) {
            this.updateItemLore(player, action, type, value, lore);
            return;
        }
        if (!type.equals("name")) {
            this.invalidArgs(player);
            return;
        }
        ItemStack playerItem = player.getInventory().getItemInMainHand();
        ItemMeta playerItemMeta = playerItem.getItemMeta();
        if (action.equals("set")) {
            if (!Utilities.checkPermissions((CommandSender)player, true, "stylizer.itemnamer.set.name", "stylizer.itemnamer.admin", "stylizer.admin")) {
                Utilities.message((CommandSender)player, this.messageHandler.string("No_Permission", "#570000Sorry, you do not have permission to do that."));
                return;
            }
            playerItemMeta.setDisplayName(Utilities.colourise(value));
            playerItem.setItemMeta(playerItemMeta);
            Utilities.message((CommandSender)player, this.messageHandler.string("ItemNamer.Set_Item_Name", "#14abc9You have set the items name to %itemName%").replace("%itemName%", playerItemMeta.getDisplayName()));
            return;
        }
        if (action.equals("remove")) {
            if (!Utilities.checkPermissions((CommandSender)player, true, "stylizer.itemnamer.remove.name", "stylizer.itemnamer.admin", "stylizer.admin")) {
                Utilities.message((CommandSender)player, this.messageHandler.string("No_Permission", "#570000Sorry, you do not have permission to do that."));
                return;
            }
            playerItemMeta.setDisplayName(Utilities.colourise("&r" + WordUtils.capitalizeFully((String)playerItem.getType().toString().replace("_", " "))));
            playerItem.setItemMeta(playerItemMeta);
            Utilities.message((CommandSender)player, this.messageHandler.string("ItemNamer.Remove_Item_Name", "#14abc9You have removed the items name"));
        }
    }

    private void updateItemLore(Player player, String action, String type, String value, List<String> lore) {
        if (player.getInventory().getItemInMainHand().getType() == Material.AIR) {
            Utilities.message((CommandSender)player, this.messageHandler.getPrefix() + "#ff4a4aPlease equip the item you are wanting to update.");
            return;
        }
        if (type.equals("name")) {
            this.updateItemName(player, action, type, value, lore);
            return;
        }
        if (!type.equals("lore")) {
            this.invalidArgs(player);
            return;
        }
        ItemStack playerItem = player.getInventory().getItemInMainHand();
        ItemMeta playerItemMeta = playerItem.getItemMeta();
        if (action.equals("set")) {
            if (!Utilities.checkPermissions((CommandSender)player, true, "stylizer.itemnamer.set.lore", "stylizer.itemnamer.admin", "stylizer.admin")) {
                Utilities.message((CommandSender)player, this.messageHandler.string("No_Permission", "#570000Sorry, you do not have permission to do that."));
                return;
            }
            playerItemMeta.setLore(Utilities.colourise(lore));
            playerItem.setItemMeta(playerItemMeta);
            Utilities.message((CommandSender)player, this.messageHandler.string("ItemNamer.Set_Item_Lore", "#14abc9You have set the items lore"));
            return;
        }
        if (action.equals("remove")) {
            if (!Utilities.checkPermissions((CommandSender)player, true, "stylizer.itemnamer.remove.lore", "stylizer.itemnamer.admin", "stylizer.admin")) {
                Utilities.message((CommandSender)player, this.messageHandler.string("No_Permission", "#570000Sorry, you do not have permission to do that."));
                return;
            }
            playerItemMeta.setLore(new ArrayList());
            playerItem.setItemMeta(playerItemMeta);
            Utilities.message((CommandSender)player, this.messageHandler.string("ItemNamer.Remove_Item_Lore", "#14abc9You have removed the items"));
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, String[] strings) {
        if (strings.length <= 1) {
            return new TabCompleteBuilder(commandSender).checkCommand("set", true, "stylizer.itemnamer.use", "stylizer.itemnamer.set.name", "stylizer.itemnamer.set.lore", "stylizer.itemnamer.admin", "stylizer.itemnamer.admin").checkCommand("remove", true, "stylizer.itemnamer.use", "stylizer.itemnamer.set.name", "stylizer.itemnamer.set.lore", "stylizer.itemnamer.admin", "stylizer.itemnamer.admin").build(strings[0]);
        }
        if (strings.length == 2 && strings[0].equalsIgnoreCase("set")) {
            return new TabCompleteBuilder(commandSender).checkCommand("name", true, "stylizer.itemnamer.set.name", "stylizer.itemnamer.admin", "stylizer.admin").checkCommand("lore", true, "stylizer.itemnamer.set.lore", "stylizer.itemnamer.admin", "stylizer.admin").build(strings[1]);
        }
        if (strings.length == 2 && strings[0].equalsIgnoreCase("remove")) {
            return new TabCompleteBuilder(commandSender).checkCommand("name", true, "stylizer.itemnamer.remove.name", "stylizer.itemnamer.admin", "stylizer.admin").checkCommand("lore", true, "stylizer.itemnamer.remove.lore", "stylizer.itemnamer.admin", "stylizer.admin").build(strings[1]);
        }
        return Collections.emptyList();
    }
}

