/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.stylizer.commands;

import java.util.Collections;
import java.util.List;
import me.omegaweapondev.libs.ou.library.Utilities;
import me.omegaweapondev.libs.ou.library.builders.TabCompleteBuilder;
import me.omegaweapondev.libs.ou.library.commands.GlobalCommand;
import me.omegaweapondev.stylizer.Stylizer;
import me.omegaweapondev.stylizer.utilities.MessageHandler;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MainCommand
extends GlobalCommand
implements TabCompleter {
    private final Stylizer plugin;
    private final MessageHandler messageHandler;
    private final String versionMessage;

    public MainCommand(Stylizer plugin) {
        this.plugin = plugin;
        this.messageHandler = new MessageHandler(plugin, plugin.getSettingsHandler().getMessagesFile().getConfig());
        this.versionMessage = this.messageHandler.getPrefix() + "&bStylizer &cv" + plugin.getDescription().getVersion() + "&b By OmegaWeaponDev";
    }

    @Override
    protected void execute(CommandSender sender, String[] strings) {
        if (strings.length == 0) {
            this.invalidArgsCommand(sender);
            return;
        }
        switch (strings[0]) {
            case "version": {
                this.versionCommand(sender);
                break;
            }
            case "help": {
                this.helpCommand(sender);
                break;
            }
            case "reload": {
                this.reloadCommand(sender);
                break;
            }
            default: {
                this.invalidArgsCommand(sender);
            }
        }
    }

    private void reloadCommand(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!Utilities.checkPermissions((CommandSender)player, true, "stylizer.reload", "stylizer.admin")) {
                Utilities.message((CommandSender)player, this.messageHandler.string("No_Permission", "&cSorry, you do not have permission for that."));
                return;
            }
            this.plugin.onReload();
            Utilities.message((CommandSender)player, this.messageHandler.string("Reload_Message", "&bOmegaNames has successfully reloaded."));
            return;
        }
        if (sender instanceof ConsoleCommandSender) {
            this.plugin.onReload();
            Utilities.logInfo(true, this.messageHandler.console("Reload_Message", "OmegaNames has successfully reloaded."));
        }
    }

    private void helpCommand(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Utilities.message((CommandSender)player, this.messageHandler.getPrefix() + "&bReload Command: &c/stylizer reload", this.messageHandler.getPrefix() + "&bVersion Command: &c/stylizer version", this.messageHandler.getPrefix() + "&bName colour command: &c/namecolour", this.messageHandler.getPrefix() + "&bChat colour command: &c/chatcolour", this.messageHandler.getPrefix() + "&bDebug Command: &c/stylizerdebug", this.messageHandler.getPrefix() + "&bItem Namer Command: &c/itemnamer <option> <value>", this.messageHandler.getPrefix() + "&bPrivate message Command: &c/privatemessage <player> <command>", this.messageHandler.getPrefix() + "&bReply Command: &c/reply <message>");
            return;
        }
        if (sender instanceof ConsoleCommandSender) {
            Utilities.logInfo(true, "&bReload Command: &c/stylizer reload", "&bVersion Command: &c/stylizer version");
        }
    }

    private void versionCommand(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Utilities.message((CommandSender)player, this.versionMessage);
            return;
        }
        if (sender instanceof ConsoleCommandSender) {
            Utilities.logInfo(true, ChatColor.stripColor((String)this.versionMessage));
        }
    }

    private void invalidArgsCommand(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Utilities.message((CommandSender)player, this.versionMessage, this.messageHandler.getPrefix() + "&bReload Command: &c/stylizer reload", this.messageHandler.getPrefix() + "&bVersion Command: &c/stylizer version", this.messageHandler.getPrefix() + "&bName colour command: &c/namecolour", this.messageHandler.getPrefix() + "&bChat colour command: &c/chatcolour", this.messageHandler.getPrefix() + "&bDebug Command: &c/stylizerdebug", this.messageHandler.getPrefix() + "&bItem Namer Command: &c/itemnamer <option> <value>", this.messageHandler.getPrefix() + "&bPrivate message Command: &c/privatemessage <player> <command>", this.messageHandler.getPrefix() + "&bReply Command: &c/reply <message>");
            return;
        }
        if (sender instanceof ConsoleCommandSender) {
            Utilities.logInfo(true, ChatColor.stripColor((String)this.versionMessage), "Reload Command: /stylizer reload", "Version Command: /stylizer version", "Debug Command: /stylizerdebug", "Item Namer Command: /itemnamer <option> <value>");
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, String[] strings) {
        if (strings.length <= 1) {
            return new TabCompleteBuilder(commandSender).checkCommand("version", true, "stylizer.admin").checkCommand("help", true, "stylizer.admin").checkCommand("reload", true, "stylizer.reload", "stylizer.admin").build(strings[0]);
        }
        return Collections.emptyList();
    }
}

