/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.stylizer.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.omegaweapondev.libs.ou.library.Utilities;
import me.omegaweapondev.libs.ou.library.builders.TabCompleteBuilder;
import me.omegaweapondev.libs.ou.library.commands.GlobalCommand;
import me.omegaweapondev.stylizer.Stylizer;
import me.omegaweapondev.stylizer.utilities.MessageHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class NameColour
extends GlobalCommand
implements TabCompleter {
    private final Stylizer plugin;
    private final MessageHandler messageHandler;
    private final FileConfiguration playerData;
    private final FileConfiguration configFile;

    public NameColour(Stylizer plugin) {
        this.plugin = plugin;
        this.messageHandler = new MessageHandler(plugin, plugin.getSettingsHandler().getMessagesFile().getConfig());
        this.playerData = plugin.getSettingsHandler().getPlayerData().getConfig();
        this.configFile = plugin.getSettingsHandler().getConfigFile().getConfig();
    }

    @Override
    protected void execute(CommandSender commandSender, String[] strings) {
        if (commandSender instanceof Player) {
            Player player = ((Player)commandSender).getPlayer();
            if (strings.length == 0) {
                this.openNameColourGUI(player);
                return;
            }
            if (strings.length == 2) {
                this.removeNameColour(player, strings);
                return;
            }
            if (strings.length == 3) {
                this.addNameColour(player, strings);
                return;
            }
        }
        if (strings.length == 0) {
            Utilities.logInfo(true, "You must be a player to open the NameColour GUI");
            return;
        }
        if (strings.length == 2 && strings[0].equalsIgnoreCase("remove")) {
            this.removeNameColour(null, strings);
            return;
        }
        if (strings.length == 3) {
            this.addNameColour(null, strings);
        }
    }

    private void openNameColourGUI(Player player) {
        if (!Utilities.checkPermissions((CommandSender)player, true, "stylizer.namecolour.open", "stylizer.admin")) {
            Utilities.message((CommandSender)player, this.messageHandler.string("No_Permission", "&cSorry, you do not have permission to do that."));
            return;
        }
        this.plugin.getNameColourGUI().openInventory(player);
    }

    private void addNameColour(Player player, String[] strings) {
        Player target = Bukkit.getPlayer((String)strings[1]);
        String nameColour = strings[2];
        if (!strings[0].equalsIgnoreCase("add")) {
            return;
        }
        if (target == null) {
            if (player != null) {
                Utilities.message((CommandSender)player, this.messageHandler.string("Invalid_Player", "&cSorry, that player cannot be found."));
                return;
            }
            Utilities.logInfo(true, "Sorry, that player cannot be found.");
            return;
        }
        if (nameColour.equalsIgnoreCase("")) {
            this.removeNameColour(player, strings);
            return;
        }
        if (target == player) {
            if (!Utilities.checkPermissions((CommandSender)player, true, "stylizer.namecolour.add.self", "stylizier.namecolour.admin", "stylizer.admin")) {
                Utilities.message((CommandSender)player, this.messageHandler.string("No_Permission", "&cSorry, you do not have permission to do that."));
                return;
            }
            target.setDisplayName(Utilities.colourise(nameColour + target.getName()));
            this.playerData.set(target.getUniqueId() + ".Name_Colour", (Object)nameColour);
            this.plugin.getSettingsHandler().getPlayerData().saveConfig();
            Utilities.message((CommandSender)target, this.messageHandler.string("Name_Colour_Applied", "&bYour name colour has been changed to: %namecolour%").replace("%namecolour%", nameColour + player.getName()));
            return;
        }
        if (!Utilities.checkPermissions((CommandSender)player, true, "stylizer.namecolour.add.others", "stylizer.namecolour.admin", "stylizer.admin")) {
            Utilities.message((CommandSender)player, this.messageHandler.string("No_Permission", "&cSorry, you do not have permission to do that."));
            return;
        }
        target.setDisplayName(Utilities.colourise(nameColour + target.getName()));
        this.playerData.set(target.getUniqueId() + ".Name_Colour", (Object)nameColour);
        this.plugin.getSettingsHandler().getPlayerData().saveConfig();
        Utilities.message((CommandSender)target, this.messageHandler.string("Name_Colour_Applied", "&bYour name colour has been changed to: %namecolour%").replace("%namecolour%", nameColour + player.getName()));
    }

    private void removeNameColour(Player player, String[] strings) {
        Player target = Bukkit.getPlayer((String)strings[1]);
        if (!strings[0].equalsIgnoreCase("remove")) {
            return;
        }
        if (target == null) {
            if (player != null) {
                Utilities.message((CommandSender)player, this.messageHandler.string("Invalid_Player", "&cSorry, that player cannot be found."));
                return;
            }
            Utilities.logInfo(true, "Sorry, that player cannot be found.");
            return;
        }
        if (target == player) {
            if (!Utilities.checkPermissions((CommandSender)player, true, "stylizer.namecolour.remove.self", "stylizier.namecolour.admin", "stylizer.admin")) {
                Utilities.message((CommandSender)player, this.messageHandler.string("No_Permission", "&cSorry, you do not have permission to do that."));
                return;
            }
            this.getNewNameColour(target);
        }
        if (!Utilities.checkPermissions((CommandSender)player, true, "stylizer.namecolour.remove.others", "stylizer.namecolour.admin", "stylizer.admin")) {
            Utilities.message((CommandSender)player, this.messageHandler.string("No_Permission", "&cSorry, you do not have permission to do that."));
            return;
        }
        this.getNewNameColour(target);
    }

    private void getNewNameColour(Player target) {
        for (String groupName : this.configFile.getConfigurationSection("Group_Name_Colour.Groups").getKeys(false)) {
            if (!Utilities.checkPermission((CommandSender)target, false, "stylizer.namecolour.groups." + groupName)) continue;
            target.setDisplayName(Utilities.colourise(this.configFile.getString("Group_Name_Colour.Groups." + groupName) + target.getName()));
            this.playerData.set(target.getUniqueId() + ".Name_Colour", null);
            this.plugin.getSettingsHandler().getPlayerData().saveConfig();
            Utilities.message((CommandSender)target, this.messageHandler.string("Name_Colour_Removed", "&cYour name colour has been reverted to the default colour"));
            return;
        }
        target.setDisplayName(Utilities.colourise(this.configFile.getString("Default_Name_Colour", "&e") + target.getName()));
        this.playerData.set(target.getUniqueId() + ".Name_Colour", (Object)this.configFile.getString("Default_Name_Colour", "&e"));
        this.plugin.getSettingsHandler().getPlayerData().saveConfig();
        Utilities.message((CommandSender)target, this.messageHandler.string("Name_Colour_Removed", "&cYour name colour has been reverted to the default colour"));
    }

    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, String[] strings) {
        if (strings.length <= 1) {
            return new TabCompleteBuilder(commandSender).checkCommand("add", true, "stylizer.namecolour.add.self", "stylizer.namecolour.add.others", "stylizer.namecolour.admin", "stylizer.admin").checkCommand("remove", true, "stylizer.namecolour.remove.self", "stylizer.namecolour.remove.others", "stylizer.namecolour.admin", "stylizer.admin").build(strings[0]);
        }
        if (strings.length <= 2 && strings[0].equalsIgnoreCase("add")) {
            ArrayList<String> players = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                players.add(player.getName());
            }
            return new TabCompleteBuilder(commandSender).addCommand(players).build(strings[1]);
        }
        if (strings.length == 2 && strings[0].equalsIgnoreCase("remove")) {
            ArrayList<String> players = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                players.add(player.getName());
            }
            return new TabCompleteBuilder(commandSender).addCommand(players).build(strings[1]);
        }
        if (strings.length == 3 && strings[0].equalsIgnoreCase("add")) {
            ArrayList<String> colours = new ArrayList<String>();
            for (ChatColor color : ChatColor.values()) {
                colours.add(color.toString().replaceAll("\u00a7", "&"));
            }
            return new TabCompleteBuilder(commandSender).addCommand(colours).build(strings[2]);
        }
        return Collections.emptyList();
    }
}

