/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.stylizer.events;

import java.text.SimpleDateFormat;
import java.util.Date;
import me.clip.placeholderapi.PlaceholderAPI;
import me.omegaweapondev.libs.ou.library.Utilities;
import me.omegaweapondev.stylizer.Stylizer;
import me.omegaweapondev.stylizer.utilities.PlayerUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChatListener
implements Listener {
    private final Stylizer plugin;
    private final FileConfiguration configFile;
    private PlayerUtil playerUtil;
    private final FileConfiguration chatlog;
    private final String defaultChatFormat;
    private final String groupChatFormat;

    public ChatListener(Stylizer plugin) {
        this.plugin = plugin;
        this.configFile = plugin.getSettingsHandler().getConfigFile().getConfig();
        this.chatlog = plugin.getSettingsHandler().getChatLog().getConfig();
        this.defaultChatFormat = this.configFile.getString("Chat_Settings.Chat_Formats.Default_Format");
        this.groupChatFormat = "Chat_Settings.Chat_Formats.Group_Formats.Groups";
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerChat(AsyncPlayerChatEvent chatEvent) {
        Player player = chatEvent.getPlayer();
        if (!this.configFile.getBoolean("Chat_Settings.Enabled")) {
            return;
        }
        this.formatChat(player, chatEvent);
    }

    private void formatChat(Player player, AsyncPlayerChatEvent chatEvent) {
        this.playerUtil = new PlayerUtil(this.plugin, player);
        for (String groupName : this.configFile.getConfigurationSection(this.groupChatFormat).getKeys(false)) {
            if (!Utilities.checkPermission((CommandSender)player, false, "stylizer.chat.groups." + groupName.toLowerCase())) continue;
            chatEvent.setFormat(this.applyFormat(player, this.configFile.getString(this.groupChatFormat + "." + groupName)));
            chatEvent.setMessage(Utilities.colourise(this.playerUtil.getChatColour() + chatEvent.getMessage()));
            this.addChatLogMessage(chatEvent, player);
            return;
        }
        chatEvent.setFormat(this.applyFormat(player, this.defaultChatFormat));
        chatEvent.setMessage(Utilities.colourise(this.playerUtil.getChatColour() + chatEvent.getMessage()));
        this.addChatLogMessage(chatEvent, player);
    }

    private String applyFormat(Player player, String configFormat) {
        this.playerUtil = new PlayerUtil(this.plugin, player);
        configFormat = configFormat.replace("%", "%%");
        configFormat = configFormat.replace("%%prefix%%", this.playerUtil.getPrefix());
        configFormat = configFormat.replace("%%suffix%%", this.playerUtil.getSuffix());
        configFormat = configFormat.replace("%%displayname%%", this.playerUtil.getNameColour() + "%1$s");
        configFormat = configFormat.replace("%%message%%", "%2$s");
        if (this.isPlaceholderAPIEnabled()) {
            return Utilities.colourise(PlaceholderAPI.setPlaceholders((Player)player, (String)configFormat));
        }
        return Utilities.colourise(configFormat);
    }

    private void addChatLogMessage(AsyncPlayerChatEvent chatEvent, Player player) {
        long currentTime = System.currentTimeMillis();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        Date date = new Date(currentTime);
        String chatLogTime = simpleDateFormat.format(date);
        if (this.configFile.getBoolean("Chat_Settings.Log_Chat_Messages")) {
            this.chatlog.set("Chat_Log." + chatLogTime, (Object)(player.getName() + " >> " + chatEvent.getMessage()));
            this.plugin.getSettingsHandler().getChatLog().saveConfig();
        }
    }

    private boolean isPlaceholderAPIEnabled() {
        return Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
    }
}

