/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.stylizer.events;

import java.util.Iterator;
import java.util.List;
import me.omegaweapondev.libs.ou.library.SpigotUpdater;
import me.omegaweapondev.libs.ou.library.Utilities;
import me.omegaweapondev.stylizer.Stylizer;
import me.omegaweapondev.stylizer.utilities.MessageAnnouncements;
import me.omegaweapondev.stylizer.utilities.MessageHandler;
import me.omegaweapondev.stylizer.utilities.PlayerUtil;
import me.omegaweapondev.stylizer.utilities.TablistManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;

public class PlayerListener
implements Listener {
    private final Stylizer plugin;
    private final FileConfiguration configFile;
    private TablistManager tablistManager;
    private PlayerUtil playerUtil;

    public PlayerListener(Stylizer plugin) {
        this.plugin = plugin;
        this.configFile = plugin.getSettingsHandler().getConfigFile().getConfig();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        this.tablistManager = new TablistManager(this.plugin, player);
        this.playerUtil = new PlayerUtil(this.plugin, player);
        player.setDisplayName(this.playerUtil.getNameColour() + player.getName() + ChatColor.RESET);
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> this.tablistManager.tablistHeaderFooter(), 100L, 400L);
        if (this.configFile.getBoolean("Tablist.Sorting_Order.Enabled")) {
            Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::sortTablist, 100L, 400L);
        } else {
            Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::formatTablistAndNames, 100L, 400L);
        }
        if (Bukkit.getOnlinePlayers().size() == 1) {
            this.messageAnnouncements();
        }
        this.SpigotUpdater(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
        if (Bukkit.getOnlinePlayers().size() - 1 <= 0) {
            Bukkit.getScheduler().cancelTasks((Plugin)this.plugin);
        }
    }

    private void formatTablistAndNames() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
            Scoreboard scoreboard = scoreboardManager.getNewScoreboard();
            Team team = scoreboard.registerNewTeam("players");
            String playerPrefix = this.plugin.getChat().getGroupPrefix(player.getWorld(), this.plugin.getChat().getPrimaryGroup(player)) != null ? this.plugin.getChat().getGroupPrefix(player.getWorld(), this.plugin.getChat().getPrimaryGroup(player)) + " " : "";
            String playerSuffix = this.plugin.getChat().getGroupSuffix(player.getWorld(), this.plugin.getChat().getPrimaryGroup(player)) != null ? this.plugin.getChat().getGroupSuffix(player.getWorld(), this.plugin.getChat().getPrimaryGroup(player)) + " " : "";
            team.addEntry(player.getName());
            if (this.configFile.getBoolean("Player_Name_Tags.Enabled") && this.configFile.getBoolean("Player_Name_Tags.Player_Prefixes")) {
                team.setPrefix(Utilities.colourise(playerPrefix));
                team.setSuffix(Utilities.colourise(playerSuffix));
                team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
            }
            if (this.configFile.getBoolean("Player_Name_Tags.Enabled")) {
                for (String nameTagGroup : this.configFile.getConfigurationSection("Player_Name_Tags.Groups").getKeys(false)) {
                    if (!Utilities.checkPermission((CommandSender)player, false, "stylizer.nametags.groups." + nameTagGroup)) continue;
                    team.setColor(ChatColor.getByChar((char)this.configFile.getString("Player_Name_Tags.Groups." + nameTagGroup).charAt(1)));
                    break;
                }
            }
            this.tablistManager = new TablistManager(this.plugin, player);
            this.tablistManager.tablistPlayerName();
            player.setScoreboard(scoreboard);
        }
    }

    private void sortTablist() {
        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
        Scoreboard scoreboard = scoreboardManager.getNewScoreboard();
        List groupNames = this.configFile.getStringList("Tablist.Sorting_Order.Order");
        for (Player player : Bukkit.getOnlinePlayers()) {
            Iterator iterator = groupNames.iterator();
            if (!iterator.hasNext()) continue;
            String groupName = (String)iterator.next();
            Team team = scoreboard.getTeam("group" + groupNames.indexOf(groupName)) == null ? scoreboard.registerNewTeam("group" + groupNames.indexOf(groupName)) : scoreboard.getTeam("group" + groupNames.indexOf(groupName));
            if (Utilities.checkPermission((CommandSender)player, false, "stylizer.tablist.order." + groupName)) {
                String playerPrefix = this.plugin.getChat().getGroupPrefix(player.getWorld(), groupName) != null ? this.plugin.getChat().getGroupPrefix(player.getWorld(), groupName) + " " : "";
                String playerSuffix = this.plugin.getChat().getGroupSuffix(player.getWorld(), groupName) != null ? this.plugin.getChat().getGroupSuffix(player.getWorld(), groupName) + " " : "";
                team.addEntry(player.getName());
                if (this.configFile.getBoolean("Player_Name_Tags.Enabled") && this.configFile.getBoolean("Player_Name_Tags.Player_Prefixes")) {
                    team.setPrefix(Utilities.colourise(playerPrefix));
                    team.setSuffix(Utilities.colourise(playerSuffix));
                    team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
                }
                if (this.configFile.getBoolean("Player_Name_Tags.Enabled")) {
                    for (String nameTagGroup : this.configFile.getConfigurationSection("Player_Name_Tags.Groups").getKeys(false)) {
                        if (!Utilities.checkPermission((CommandSender)player, false, "stylizer.nametags.groups." + nameTagGroup)) continue;
                        team.setColor(ChatColor.getByChar((char)this.configFile.getString("Player_Name_Tags.Groups." + nameTagGroup).charAt(1)));
                        break;
                    }
                }
            }
            this.tablistManager = new TablistManager(this.plugin, player);
            this.tablistManager.tablistPlayerName();
            player.setScoreboard(scoreboard);
        }
    }

    private void SpigotUpdater(@NotNull Player player) {
        if (!this.configFile.getBoolean("Update_Messages")) {
            return;
        }
        if (Utilities.checkPermissions((CommandSender)player, true, "stylizer.update", "stylizer.admin")) {
            new SpigotUpdater((Plugin)this.plugin, 78327).getVersion(version -> {
                int spigotVersion = Integer.parseInt(version.replace(".", ""));
                int pluginVersion = Integer.parseInt(this.plugin.getDescription().getVersion().replace(".", ""));
                if (pluginVersion >= spigotVersion) {
                    MessageHandler messageHandler = new MessageHandler(this.plugin, this.plugin.getSettingsHandler().getMessagesFile().getConfig());
                    Utilities.message((CommandSender)player, messageHandler.getPrefix() + "#00D4FFYou are already running the latest version");
                    return;
                }
                PluginDescriptionFile pdf = this.plugin.getDescription();
                Utilities.message((CommandSender)player, "#00D4FFA new version of #FF4A4A" + pdf.getName() + " #00D4FFis avaliable!", "#00D4FFCurrent Version: #FF4A4A" + pdf.getVersion() + " #00D4FF> New Version: #FF4A4A" + version, "#00D4FFGrab it here:#FF4A4A https://www.spigotmc.org/resources/stylizer.78327/");
            });
        }
    }

    private void messageAnnouncements() {
        if (!this.configFile.getBoolean("Announcement_Messages.Enabled")) {
            return;
        }
        if (this.configFile.getConfigurationSection("Announcement_Messages.Messages").getKeys(false).isEmpty()) {
            return;
        }
        MessageAnnouncements messageAnnouncements = new MessageAnnouncements(this.plugin);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, messageAnnouncements::broadcastAnnouncements, 20L * (long)this.plugin.getSettingsHandler().getConfigFile().getConfig().getInt("Announcement_Messages.Interval"), 20L * (long)this.plugin.getSettingsHandler().getConfigFile().getConfig().getInt("Announcement_Messages.Interval"));
    }
}

