/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.stylizer.menus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.omegaweapondev.libs.ou.library.Utilities;
import me.omegaweapondev.libs.ou.library.builders.ItemBuilder;
import me.omegaweapondev.libs.ou.library.menus.MenuCreator;
import me.omegaweapondev.stylizer.Stylizer;
import me.omegaweapondev.stylizer.utilities.GUIPermissionsChecker;
import me.omegaweapondev.stylizer.utilities.MessageHandler;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;

public class ChatColours
extends MenuCreator {
    private final Stylizer plugin;
    private final MessageHandler messageHandler;
    private ItemBuilder itemBuilder;
    private final FileConfiguration configFile;

    public ChatColours(Stylizer plugin) {
        super(4, plugin.getSettingsHandler().getMessagesFile().getConfig().getString("Chat_Colour_GUI.GUI_Title"), "#6928f7&lChatColours");
        this.plugin = plugin;
        this.configFile = plugin.getSettingsHandler().getConfigFile().getConfig();
        this.messageHandler = new MessageHandler(plugin, plugin.getSettingsHandler().getMessagesFile().getConfig());
        int slot = -2;
        for (String itemName : this.configFile.getConfigurationSection("Chat_Colour_Items").getKeys(false)) {
            if (slot++ > 33) {
                Utilities.logWarning(true, "You can only have 33 colours in the Chat Colour GUI!");
                return;
            }
            this.createItem(slot + 1, this.configFile.getString("Chat_Colour_Items." + itemName + ".Item"), itemName, this.configFile.getString("Chat_Colour_Items." + itemName + ".Colour"));
        }
        this.setItem(34, this.createItemStack("SPONGE", Utilities.colourise("#570000Current"), Utilities.colourise(Arrays.asList("#ff4a4aClick here to view", "#ff4a4ayour current chat colour"))), player -> Utilities.message((CommandSender)player, this.messageHandler.string("Current_Chat_Colour", "#14abc9Your name colour has been changed to: %chatcolour%").replace("%chatcolour%", plugin.getSettingsHandler().getPlayerData().getConfig().getString(player.getUniqueId() + ".Chat_Colour"))));
    }

    private void createItem(Integer slot, String material, String name, String colour) {
        this.setItem(slot, this.createItemStack(material, Utilities.colourise(colour + name), Utilities.colourise(this.loreMessage(this.messageHandler.stringList("Chat_Colour_GUI.Colour_Lore", Arrays.asList("#ff4a4aClick here to change", "#ff4a4ayour chat colour to", colour + name)), colour + name))), player -> {
            GUIPermissionsChecker permChecker = new GUIPermissionsChecker(this.plugin, player, name, colour);
            permChecker.chatColourPermsCheck();
        });
    }

    private List<String> loreMessage(List<String> lore, String name) {
        ArrayList<String> formattedLore = new ArrayList<String>();
        for (String message : lore) {
            formattedLore.add(message.replace("%chatcolour%", name));
        }
        return formattedLore;
    }

    private ItemStack createItemStack(String material, String name, List<String> lore) {
        this.itemBuilder = new ItemBuilder(Material.getMaterial((String)material.toUpperCase()));
        return this.itemBuilder.checkInvalidMaterial(material, name, lore);
    }
}

