/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.stylizer.menus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.omegaweapondev.libs.ou.library.Utilities;
import me.omegaweapondev.libs.ou.library.builders.ItemBuilder;
import me.omegaweapondev.libs.ou.library.menus.MenuCreator;
import me.omegaweapondev.stylizer.Stylizer;
import me.omegaweapondev.stylizer.utilities.GUIPermissionsChecker;
import me.omegaweapondev.stylizer.utilities.MessageHandler;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;

public class NameColours
extends MenuCreator {
    private final Stylizer plugin;
    private final MessageHandler messageHandler;
    private ItemBuilder itemBuilder;
    private final FileConfiguration configFile;

    public NameColours(Stylizer plugin) {
        super(4, plugin.getSettingsHandler().getMessagesFile().getConfig().getString("Name_Colour_GUI.GUI_Title"), "#6928f7&lNameColours");
        this.plugin = plugin;
        this.configFile = plugin.getSettingsHandler().getConfigFile().getConfig();
        this.messageHandler = new MessageHandler(plugin, plugin.getSettingsHandler().getMessagesFile().getConfig());
        int slot = -2;
        for (String itemName : this.configFile.getConfigurationSection("Name_Colour_Items").getKeys(false)) {
            if (slot++ > 33) {
                Utilities.logWarning(true, "You can only have 33 colours in the Name Colour GUI!");
                return;
            }
            this.createItem(slot + 1, this.configFile.getString("Name_Colour_Items." + itemName + ".Item"), itemName, this.configFile.getString("Name_Colour_Items." + itemName + ".Colour"));
        }
        this.setItem(34, this.createItemStack("SPONGE", Utilities.colourise("#570000Current"), Utilities.colourise(Arrays.asList("#ff4a4aClick here to view", "#ff4a4ayour current name colour"))), player -> Utilities.message((CommandSender)player, this.messageHandler.string("Current_Name_Colour", "#14abc9Your name colour has been changed to: %namecolour%").replace("%namecolour%", player.getDisplayName())));
    }

    private void createItem(Integer slot, String material, String name, String colour) {
        this.setItem(slot, this.createItemStack(material, Utilities.colourise(colour + name), Utilities.colourise(this.loreMessage(this.messageHandler.stringList("Name_Colour_GUI.Colour_Lore", Arrays.asList("&cClick here to change", "&cyour name colour to", colour + name)), colour + name))), player -> {
            GUIPermissionsChecker permChecker = new GUIPermissionsChecker(this.plugin, player, name, colour);
            permChecker.nameColourPermsCheck();
        });
    }

    private List<String> loreMessage(List<String> lore, String name) {
        ArrayList<String> formattedLore = new ArrayList<String>();
        for (String message : lore) {
            formattedLore.add(message.replace("%namecolour%", name));
        }
        return formattedLore;
    }

    private ItemStack createItemStack(String material, String name, List<String> lore) {
        this.itemBuilder = new ItemBuilder(Material.getMaterial((String)material.toUpperCase()));
        return this.itemBuilder.checkInvalidMaterial(material, name, lore);
    }
}

