/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.stylizer.utilities;

import me.omegaweapondev.libs.ou.library.Utilities;
import me.omegaweapondev.stylizer.Stylizer;
import me.omegaweapondev.stylizer.utilities.MessageHandler;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class GUIPermissionsChecker {
    private final Stylizer plugin;
    private final MessageHandler messageHandler;
    private final FileConfiguration configFile;
    private final FileConfiguration playerData;
    private final Player player;
    private final String name;
    private final String colour;

    public GUIPermissionsChecker(Stylizer plugin, Player player, String name, String colour) {
        this.plugin = plugin;
        this.player = player;
        this.name = name;
        this.colour = colour;
        this.messageHandler = new MessageHandler(plugin, plugin.getSettingsHandler().getMessagesFile().getConfig());
        this.configFile = plugin.getSettingsHandler().getConfigFile().getConfig();
        this.playerData = plugin.getSettingsHandler().getPlayerData().getConfig();
    }

    public void nameColourPermsCheck() {
        if (this.configFile.getBoolean("Per_Name_Colour_Permissions")) {
            this.perNameColourPerms();
            return;
        }
        if (!Utilities.checkPermissions((CommandSender)this.player, true, "stylizer.namecolour.colours", "stylizer.admin")) {
            Utilities.message((CommandSender)this.player, this.messageHandler.string("No_Permission", "#570000Sorry, you do not have permission to do that."));
            return;
        }
        this.player.setDisplayName(Utilities.colourise(this.colour + this.player.getName() + "&r"));
        this.playerData.set(this.player.getUniqueId() + ".Name_Colour", (Object)this.colour);
        this.plugin.getSettingsHandler().getPlayerData().saveConfig();
        Utilities.message((CommandSender)this.player, this.messageHandler.string("Name_Colour_Applied", "#14abc9Your name colour has been changed to: %namecolour%").replace("%namecolour%", this.colour + this.player.getName()));
    }

    private void perNameColourPerms() {
        if (!Utilities.checkPermissions((CommandSender)this.player, true, "stylizer.namecolour.colour." + this.name.replace(" ", "").toLowerCase(), "stylizer.namecolour.colour.all", "stylizer.admin")) {
            Utilities.message((CommandSender)this.player, this.messageHandler.string("No_Permission", "#570000Sorry, you do not have permission to do that."));
            return;
        }
        this.player.setDisplayName(Utilities.colourise(this.colour + this.player.getName() + "&r"));
        if (!this.playerData.isConfigurationSection(this.player.getUniqueId().toString())) {
            this.plugin.getSettingsHandler().getPlayerData().getConfig().createSection(this.player.getUniqueId().toString());
        }
        this.playerData.set(this.player.getUniqueId() + ".Name_Colour", (Object)this.colour);
        this.plugin.getSettingsHandler().getPlayerData().saveConfig();
        Utilities.message((CommandSender)this.player, this.messageHandler.string("Name_Colour_Applied", "#14abc9Your name colour has been changed to: %namecolour%").replace("%namecolour%", this.colour + this.player.getName()));
    }

    public void chatColourPermsCheck() {
        if (this.configFile.getBoolean("Per_Chat_Colour_Permissions")) {
            this.perChatColourPerms();
            return;
        }
        if (!Utilities.checkPermissions((CommandSender)this.player, true, "stylizer.chatcolour.colours", "stylizer.admin")) {
            Utilities.message((CommandSender)this.player, this.messageHandler.string("No_Permission", "#570000Sorry, you do not have permission to do that."));
            return;
        }
        this.playerData.set(this.player.getUniqueId() + ".Chat_Colour", (Object)this.colour);
        this.plugin.getSettingsHandler().getPlayerData().saveConfig();
        Utilities.message((CommandSender)this.player, this.messageHandler.string("Chat_Colour_Applied", "#14abc9Your chat colour has been changed to: %chatcolour%").replace("%chatcolour%", this.colour + this.player.getName()));
    }

    private void perChatColourPerms() {
        if (!Utilities.checkPermissions((CommandSender)this.player, true, "stylizer.chatcolour.colour." + this.name.replace(" ", "").toLowerCase(), "stylizer.chatcolour.colour.all", "stylizer.admin")) {
            Utilities.message((CommandSender)this.player, this.messageHandler.string("No_Permission", "#570000Sorry, you do not have permission to do that."));
            return;
        }
        if (!this.playerData.isConfigurationSection(this.player.getUniqueId().toString())) {
            this.plugin.getSettingsHandler().getPlayerData().getConfig().createSection(this.player.getUniqueId().toString());
        }
        this.playerData.set(this.player.getUniqueId() + ".Chat_Colour", (Object)this.colour);
        this.plugin.getSettingsHandler().getPlayerData().saveConfig();
        Utilities.message((CommandSender)this.player, this.messageHandler.string("Chat_Colour_Applied", "#14abc9Your chat colour has been changed to: %chatcolour%").replace("%chatcolour%", this.colour + this.player.getName()));
    }
}

