/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.stylizer.utilities;

import java.util.ArrayList;
import java.util.Random;
import me.clip.placeholderapi.PlaceholderAPI;
import me.omegaweapondev.libs.ou.library.Utilities;
import me.omegaweapondev.libs.ou.library.chat.ChatComponent;
import me.omegaweapondev.stylizer.Stylizer;
import me.omegaweapondev.stylizer.utilities.MessageHandler;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MessageAnnouncements {
    private final Stylizer plugin;
    private final FileConfiguration configFile;
    private final MessageHandler messageHandler;

    public MessageAnnouncements(Stylizer plugin) {
        this.plugin = plugin;
        this.configFile = plugin.getSettingsHandler().getConfigFile().getConfig();
        this.messageHandler = new MessageHandler(plugin, plugin.getSettingsHandler().getMessagesFile().getConfig());
    }

    public void broadcastAnnouncements() {
        Random rand = new Random();
        ArrayList messages = new ArrayList(this.configFile.getConfigurationSection("Announcement_Messages.Messages").getKeys(false));
        String announcement = (String)messages.get(rand.nextInt(messages.size()));
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.configFile.getBoolean("Announcement_Messages.Messages." + announcement + ".Hover.Enabled")) {
                this.sendWithHover(player, announcement);
                continue;
            }
            this.sendWithoutHover(player, announcement);
        }
    }

    private String getHoverMessage(@NotNull String announcement) {
        StringBuilder hoverMessage = new StringBuilder();
        for (String hoverMessageRaw : this.configFile.getStringList("Announcement_Messages.Messages." + announcement + ".Hover.Hover_Message")) {
            hoverMessage.append(hoverMessageRaw).append("\n");
        }
        return hoverMessage.toString();
    }

    private void sendWithHover(@NotNull Player onlinePlayer, @NotNull String announcement) {
        ChatComponent announcementWithPapi = new ChatComponent(PlaceholderAPI.setPlaceholders((Player)onlinePlayer, (String)Utilities.colourise(this.configFile.getString("Announcement_Messages.Messages." + announcement + ".Message")))).onHover(HoverEvent.Action.SHOW_TEXT, PlaceholderAPI.setPlaceholders((Player)onlinePlayer, (String)Utilities.colourise(this.getHoverMessage(announcement))));
        ChatComponent announcementWithoutPapi = new ChatComponent(Utilities.colourise(this.configFile.getString("Announcement_Messages.Messages." + announcement + ".Message"))).onHover(HoverEvent.Action.SHOW_TEXT, Utilities.colourise(this.getHoverMessage(announcement)));
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            announcementWithPapi.send(onlinePlayer);
        } else {
            announcementWithoutPapi.send(onlinePlayer);
        }
    }

    private void sendWithoutHover(@NotNull Player player, @NotNull String announcement) {
        ChatComponent announcementWithPapi = new ChatComponent(PlaceholderAPI.setPlaceholders((Player)player, (String)Utilities.colourise(this.configFile.getString("Announcement_Messages.Messages." + announcement + ".Message"))));
        ChatComponent announcementWithoutPapi = new ChatComponent(Utilities.colourise(this.configFile.getString("Announcement_Messages.Messages." + announcement + ".Message")));
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            announcementWithPapi.send(player);
        } else {
            announcementWithoutPapi.send(player);
        }
    }
}

