/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.stylizer.utilities;

import java.util.List;
import me.omegaweapondev.libs.ou.library.Utilities;
import me.omegaweapondev.stylizer.Stylizer;
import org.bukkit.configuration.file.FileConfiguration;

public class MessageHandler {
    private final Stylizer plugin;
    private final FileConfiguration messagesConfig;
    private final String configName;

    public MessageHandler(Stylizer plugin, FileConfiguration messagesConfig) {
        this.plugin = plugin;
        this.messagesConfig = messagesConfig;
        this.configName = plugin.getSettingsHandler().getMessagesFile().getFileName();
    }

    public String string(String message, String fallbackMessage) {
        if (this.messagesConfig.getString(message) == null) {
            this.getErrorMessage(message);
            return this.getPrefix() + fallbackMessage;
        }
        return this.getPrefix() + this.messagesConfig.getString(message);
    }

    public String console(String message, String fallbackMessage) {
        if (this.messagesConfig.getString(message) == null) {
            this.getErrorMessage(message);
            return fallbackMessage;
        }
        return this.messagesConfig.getString(message);
    }

    public List<String> stringList(String message, List<String> fallbackMessage) {
        if (this.messagesConfig.getStringList(message).size() == 0) {
            this.getErrorMessage(message);
            return fallbackMessage;
        }
        return this.messagesConfig.getStringList(message);
    }

    public String getPrefix() {
        if (this.messagesConfig.getString("Prefix") == null || this.messagesConfig.getString("Prefix").equals("")) {
            return "";
        }
        return this.messagesConfig.getString("Prefix") + " ";
    }

    private void getErrorMessage(String message) {
        Utilities.logInfo(true, "There was an error getting the " + message + " message from the " + this.configName + ".", "I have set a fallback message to take it's place until the issue is fixed.", "To resolve this, please locate " + message + " in the " + this.configName + " and fix the issue.");
    }
}

