/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.stylizer.utilities;

import me.omegaweapondev.libs.ou.library.Utilities;
import me.omegaweapondev.stylizer.Stylizer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlayerUtil {
    private final Stylizer plugin;
    private final Player player;
    private final FileConfiguration configFile;
    private final FileConfiguration userData;

    public PlayerUtil(@NotNull Stylizer plugin, @NotNull Player player) {
        this.plugin = plugin;
        this.player = player;
        this.configFile = plugin.getSettingsHandler().getConfigFile().getConfig();
        this.userData = plugin.getSettingsHandler().getPlayerData().getConfig();
    }

    public String getNameColour() {
        if (this.userData.getString(this.player.getUniqueId() + ".Name_Colour") != null) {
            return this.userData.getString(this.player.getUniqueId() + ".Name_Colour");
        }
        if (!this.configFile.getBoolean("Group_Name_Colour.Enabled")) {
            return this.configFile.getString("Default_Name_Colour");
        }
        for (String groupName : this.configFile.getConfigurationSection("Group_Name_Colour.Groups").getKeys(false)) {
            if (!Utilities.checkPermission((CommandSender)this.player, false, "stylizer.namecolour.groups." + groupName.toLowerCase())) continue;
            return this.configFile.getString("Group_Name_Colour.Groups." + groupName);
        }
        return this.configFile.getString("Default_Name_Colour");
    }

    public String getChatColour() {
        if (this.userData.getString(this.player.getUniqueId() + ".Chat_Colour") != null) {
            return this.userData.getString(this.player.getUniqueId() + ".Chat_Colour");
        }
        if (!this.configFile.getBoolean("Group_Chat_Colour.Enabled")) {
            return this.configFile.getString("Default_Chat_Colour");
        }
        for (String groupName : this.configFile.getConfigurationSection("Group_Chat_Colour.Groups").getKeys(false)) {
            if (!Utilities.checkPermission((CommandSender)this.player, false, "stylizer.chatcolour.groups." + groupName.toLowerCase())) continue;
            return this.configFile.getString("Group_Chat_Colour.Groups." + groupName);
        }
        return this.configFile.getString("Default_Chat_Colour");
    }

    public String getPrefix() {
        return this.plugin.getChat().getPlayerPrefix(this.player) != null ? this.plugin.getChat().getPlayerPrefix(this.player) + " " : "";
    }

    public String getSuffix() {
        return this.plugin.getChat().getPlayerSuffix(this.player) != null ? " " + this.plugin.getChat().getPlayerSuffix(this.player) + " " : "";
    }
}

