/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.stylizer.utilities;

import java.io.IOException;
import java.util.Arrays;
import me.omegaweapondev.libs.ou.library.Utilities;
import me.omegaweapondev.libs.ou.library.configs.ConfigCreator;
import me.omegaweapondev.libs.ou.library.configs.ConfigUpdater;
import me.omegaweapondev.stylizer.Stylizer;
import org.bukkit.plugin.Plugin;

public class SettingsHandler {
    private final Stylizer plugin;
    private final ConfigCreator configFile = new ConfigCreator("config.yml");
    private final ConfigCreator messagesFile = new ConfigCreator("messages.yml");
    private final ConfigCreator playerData = new ConfigCreator("playerData.yml");
    private final ConfigCreator chatLog = new ConfigCreator("chatlog.yml");

    public SettingsHandler(Stylizer plugin) {
        this.plugin = plugin;
    }

    public void setupConfigs() {
        this.getConfigFile().createConfig();
        this.getMessagesFile().createConfig();
        this.getPlayerData().createConfig();
        this.getChatLog().createConfig();
        this.getChatLog().getConfig().options().header(" -------------------------------------------------------------------------------------------\n \n Welcome to Stylizer's Chat Log.\n \n Below will be a list of all the chat messages that have been said.\n The format used to log chat messages is <timestamp>: <players name> >> <message>\n \n -------------------------------------------------------------------------------------------");
        this.getChatLog().saveConfig();
        this.getPlayerData().getConfig().options().header(" -------------------------------------------------------------------------------------------\n \n Welcome to Stylizer Player Data file.\n \n This file contains all the uuids and namecolour colours\n for all the players who have the permission stylizer.login\n \n -------------------------------------------------------------------------------------------");
        this.getPlayerData().saveConfig();
    }

    public void configUpdater() {
        Utilities.logInfo(true, "Attempting to update the config files....");
        try {
            if (this.getConfigFile().getConfig().getDouble("Config_Version") != 2.1) {
                this.getConfigFile().getConfig().set("Config_Version", (Object)2.1);
                this.getConfigFile().saveConfig();
                ConfigUpdater.update((Plugin)this.plugin, "config.yml", this.getConfigFile().getFile(), Arrays.asList("Group_Name_Colour.Groups", "Group_Chat_Colour.Groups", "Name_Colour_Items", "Chat_Colour_Items", "Chat_Settings.Chat_Formats.Group_Formats.Groups"));
                Utilities.logInfo(true, "Stylizer has automatically updated your config.yml!");
            }
            if (this.getMessagesFile().getConfig().getDouble("Config_Version") != 2.1) {
                this.getMessagesFile().getConfig().set("Config_Version.", (Object)2.1);
                this.getMessagesFile().saveConfig();
                ConfigUpdater.update((Plugin)this.plugin, "messages.yml", this.getMessagesFile().getFile(), Arrays.asList("none"));
                Utilities.logInfo(true, "Stylizer has automatically updated your messages.yml!");
            }
            this.reloadFiles();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void reloadFiles() {
        this.getConfigFile().reloadConfig();
        this.getMessagesFile().reloadConfig();
        this.getChatLog().reloadConfig();
        this.getPlayerData().reloadConfig();
    }

    public ConfigCreator getConfigFile() {
        return this.configFile;
    }

    public ConfigCreator getMessagesFile() {
        return this.messagesFile;
    }

    public ConfigCreator getPlayerData() {
        return this.playerData;
    }

    public ConfigCreator getChatLog() {
        return this.chatLog;
    }
}

