/*
 * Decompiled with CFR 0.152.
 */
package me.omegaweapondev.stylizer.utilities;

import me.clip.placeholderapi.PlaceholderAPI;
import me.omegaweapondev.libs.ou.library.Utilities;
import me.omegaweapondev.stylizer.Stylizer;
import me.omegaweapondev.stylizer.utilities.PlayerUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class TablistManager {
    private final Stylizer plugin;
    private final FileConfiguration configFile;
    private final Player player;
    public final String playerPrefix;
    public final String playerSuffix;
    private final boolean isPlaceholderAPI;
    private final PlayerUtil playerUtil;

    public TablistManager(Stylizer plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.configFile = plugin.getSettingsHandler().getConfigFile().getConfig();
        this.isPlaceholderAPI = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
        this.playerUtil = new PlayerUtil(plugin, player);
        this.playerPrefix = this.playerUtil.getPrefix();
        this.playerSuffix = this.playerUtil.getSuffix();
    }

    public void tablistHeaderFooter() {
        if (!this.configFile.getBoolean("Tablist.Enabled")) {
            return;
        }
        StringBuilder header = new StringBuilder();
        StringBuilder footer = new StringBuilder();
        if (this.isPlaceholderAPI) {
            for (String headerMessage : this.configFile.getStringList("Tablist.Tablist_Header")) {
                header.append(headerMessage.replace("%player%", this.playerPrefix + this.playerUtil.getNameColour() + this.player.getName())).append("\n");
            }
            this.player.setPlayerListHeader(PlaceholderAPI.setPlaceholders((Player)this.player, (String)Utilities.colourise(header.toString())));
            for (String footerMessage : this.configFile.getStringList("Tablist.Tablist_Footer")) {
                footer.append(footerMessage.replace("%player%", this.playerPrefix + this.playerUtil.getNameColour() + this.player.getName())).append("\n");
            }
            this.player.setPlayerListFooter(PlaceholderAPI.setPlaceholders((Player)this.player, (String)Utilities.colourise(footer.toString())));
            return;
        }
        for (String headerMessage : this.configFile.getStringList("Tablist.Tablist_Header")) {
            header.append(headerMessage.replace("%player%", this.playerPrefix + this.playerUtil.getNameColour() + this.player.getName())).append("\n");
        }
        this.player.setPlayerListHeader(Utilities.colourise(header.toString()));
        for (String footerMessage : this.configFile.getStringList("Tablist.Tablist_Footer")) {
            footer.append(footerMessage.replace("%player%", this.playerPrefix + this.playerUtil.getNameColour() + this.player.getName())).append("\n");
        }
        this.player.setPlayerListFooter(Utilities.colourise(footer.toString()));
    }

    public void tablistPlayerName() {
        if (!this.configFile.getBoolean("Tablist.Enabled") && !this.configFile.getBoolean("Tablist.Player_Name_Formats.Enabled")) {
            return;
        }
        if (!this.configFile.getBoolean("Tablist.Player_Name_Formats.Group_Formats.Enabled")) {
            this.player.setPlayerListName(this.setFormat(this.player, this.configFile.getString("Tablist.Player_Name_Formats.Default_Format")));
            return;
        }
        for (String groupName : this.configFile.getConfigurationSection("Tablist.Player_Name_Formats.Group_Formats.Groups").getKeys(false)) {
            if (!Utilities.checkPermissions((CommandSender)this.player, false, "stylizer.tablist.groups." + groupName)) continue;
            this.player.setPlayerListName(this.setFormat(this.player, this.configFile.getString("Tablist.Player_Name_Formats.Group_Formats.Groups." + groupName)));
            return;
        }
    }

    private String setFormat(@NotNull Player player, @NotNull String tablistFormat) {
        String finalFormat = tablistFormat.replace("%playername%", player.getName());
        finalFormat = finalFormat.replace("%displayname%", this.playerUtil.getNameColour() + player.getName());
        finalFormat = finalFormat.replace("%prefix%", this.playerPrefix);
        finalFormat = finalFormat.replace("%suffix%", this.playerSuffix);
        if (this.isPlaceholderAPI) {
            return Utilities.colourise(PlaceholderAPI.setPlaceholders((Player)player, (String)finalFormat));
        }
        return Utilities.colourise(finalFormat);
    }
}

