/*
 * Decompiled with CFR 0.152.
 */
package me.username.witch;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.username.witch.Game;
import me.username.witch.Yaml;
import me.username.witch.YamlPos;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin
implements Listener {
    List<Game> games;
    FileConfiguration config = this.getConfig();
    FileConfiguration pconfig;
    int curGame = 0;
    boolean makingSign;
    boolean bungee;
    boolean enclosedChat;
    String joinMsg;
    String leaveMsg;

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        this.games = new ArrayList<Game>();
        this.getConfig();
        this.getConfig().addDefault("games", (Object)2);
        this.getConfig().addDefault("playerstostart", (Object)5);
        this.getConfig().addDefault("bungee", (Object)false);
        this.getConfig().addDefault("enclosedchat", (Object)true);
        this.getConfig().addDefault("Points.All.pickupdust", (Object)1);
        this.getConfig().addDefault("Points.All.getfirestick", (Object)5);
        this.getConfig().addDefault("Points.Civil.killwitch", (Object)20);
        this.getConfig().addDefault("Points.Civil.killcivil", (Object)-20);
        this.getConfig().addDefault("Points.Witch.killcivil", (Object)10);
        this.getConfig().addDefault("Points.Witch.killdetective", (Object)15);
        this.getConfig().addDefault("Messages.All.Deaths.playerpossessed", (Object)"&cDeath &7| &dA player was &5POSSESSED!");
        this.getConfig().addDefault("Messages.All.Deaths.playerburned", (Object)"&cDeath &7| &aA player was &6BURNED!");
        this.getConfig().addDefault("Messages.All.Deaths.playerexecuted", (Object)"&cDeath &7| &aA player was &7EXECUTED!");
        this.getConfig().addDefault("Messages.All.Starting.countdown", (Object)"&5Witch &7| &3Game starting in &6%seconds% &3seconds!");
        this.getConfig().addDefault("Messages.All.Starting.started", (Object)"&5Witch &7| &3The game has started!");
        this.getConfig().addDefault("Messages.All.Starting.failed", (Object)"&5Witch &7| &cNot enough players to start! %required% players required!");
        this.getConfig().addDefault("Messages.All.Game.pickupdust", (Object)"&6+%points% Points (picking up fire dust)");
        this.getConfig().addDefault("Messages.All.Game.joinmsg", (Object)"&f%player% &6joined the town! &8(&7%players%&8/&7%max%&8)");
        this.getConfig().addDefault("Messages.All.Game.leavemsg", (Object)"&f%player% &6left the town.");
        this.getConfig().addDefault("Messages.All.Game.earnfirestick", (Object)"&6+%points% Points (earning fire stick)");
        this.getConfig().addDefault("Messages.Civil.killwitch", (Object)"&6&l+%points% &6Points for killing the Witch!");
        this.getConfig().addDefault("Messages.Civil.killcivil", (Object)"&c&l%points% &cPoints for killing a civilian!");
        this.getConfig().addDefault("Messages.Witch.killcivil", (Object)"&6&l+%points% &6Points (killing civilian)");
        this.getConfig().addDefault("Messages.Witch.killdetective", (Object)"&6&l+%points% &6Points (killing detective)");
        this.getConfig().addDefault("Messages.All.End.civilwin", (Object)"&5Witch &7| &aThe Civilians &2have WON!");
        this.getConfig().addDefault("Messages.All.End.witchwin", (Object)"&5Witch &7| &5The Witch &dhas WON!");
        this.getConfig().options().copyDefaults(true);
        this.bungee = this.getConfig().getBoolean("bungee");
        this.enclosedChat = this.getConfig().getBoolean("enclosedchat");
        this.joinMsg = this.getConfig().getString("Messages.All.Game.joinmsg").replace("&", "\u00a7");
        this.leaveMsg = this.getConfig().getString("Messages.All.Game.leavemsg").replace("&", "\u00a7");
        this.saveConfig();
        if (!this.bungee) {
            for (int i = 0; i < this.getConfig().getInt("games"); ++i) {
                Game game = new Game(this, i);
                this.games.add(game);
                this.getConfig();
                this.getConfig().addDefault("JoinSigns.game" + i + ".x", (Object)0);
                this.getConfig().addDefault("JoinSigns.game" + i + ".y", (Object)0);
                this.getConfig().addDefault("JoinSigns.game" + i + ".z", (Object)0);
                this.getConfig().options().copyDefaults(true);
                this.saveConfig();
            }
        } else {
            Game game = new Game(this, 0);
            this.games.add(game);
            this.getConfig().addDefault("JoinSigns.game1.x", (Object)0);
            this.getConfig().addDefault("JoinSigns.game1.y", (Object)0);
            this.getConfig().addDefault("JoinSigns.game1.z", (Object)0);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Object yaml;
        if (cmd.getName().equalsIgnoreCase("addToGame") && args.length == 1) {
            this.games.get((int)Integer.parseInt((String)args[0])).inGamePlayers.add((Player)sender);
        }
        if (cmd.getName().equalsIgnoreCase("start")) {
            for (Game game : this.games) {
                if (!game.inGamePlayers.contains(sender)) continue;
                game.Initiate();
            }
        }
        if (cmd.getName().equalsIgnoreCase("stats")) {
            if (args.length != 0) {
                OfflinePlayer player = Bukkit.getOfflinePlayer((String)args[0]);
                if (player != null && player.hasPlayedBefore()) {
                    Yaml yaml2 = this.getPlayerStatsYaml(player.getUniqueId().toString());
                    sender.sendMessage(Game.sendCenteredMessage(ChatColor.GOLD + ChatColor.STRIKETHROUGH.toString() + "                " + ChatColor.WHITE + " " + player.getName() + "'s Stats " + ChatColor.GOLD + ChatColor.STRIKETHROUGH.toString() + "                "));
                    sender.sendMessage(" ");
                    sender.sendMessage(Game.sendCenteredMessage(ChatColor.DARK_AQUA + "Points: " + ChatColor.AQUA + yaml2.Get("points")));
                    sender.sendMessage(Game.sendCenteredMessage(ChatColor.DARK_AQUA + "Kills: " + ChatColor.AQUA + yaml2.Get("kills")));
                    sender.sendMessage(Game.sendCenteredMessage(ChatColor.DARK_AQUA + "Deaths: " + ChatColor.AQUA + yaml2.Get("deaths")));
                    sender.sendMessage(Game.sendCenteredMessage(ChatColor.DARK_AQUA + "Games Played: " + ChatColor.AQUA + yaml2.Get("played")));
                    sender.sendMessage(Game.sendCenteredMessage(ChatColor.GOLD + "\u00a7m                                              "));
                    yaml2.Save();
                } else {
                    sender.sendMessage("That player has no stats!");
                }
            } else {
                yaml = this.getPlayerStatsYaml(((Player)sender).getUniqueId().toString());
                sender.sendMessage(Game.sendCenteredMessage(ChatColor.GOLD + ChatColor.STRIKETHROUGH.toString() + "                " + ChatColor.WHITE + " " + sender.getName() + "'s Stats " + ChatColor.GOLD + ChatColor.STRIKETHROUGH.toString() + "                "));
                sender.sendMessage(" ");
                sender.sendMessage(Game.sendCenteredMessage(ChatColor.DARK_AQUA + "Points: " + ChatColor.AQUA + ((Yaml)yaml).Get("points")));
                sender.sendMessage(Game.sendCenteredMessage(ChatColor.DARK_AQUA + "Kills: " + ChatColor.AQUA + ((Yaml)yaml).Get("kills")));
                sender.sendMessage(Game.sendCenteredMessage(ChatColor.DARK_AQUA + "Deaths: " + ChatColor.AQUA + ((Yaml)yaml).Get("deaths")));
                sender.sendMessage(Game.sendCenteredMessage(ChatColor.DARK_AQUA + "Games Played: " + ChatColor.AQUA + ((Yaml)yaml).Get("played")));
                sender.sendMessage(Game.sendCenteredMessage(ChatColor.GOLD + "\u00a7m                                              "));
                ((Yaml)yaml).Save();
            }
        }
        if (cmd.getName().equalsIgnoreCase("leaveGame")) {
            if (!this.bungee) {
                for (Game game : this.games) {
                    if (!game.inGamePlayers.contains(sender)) continue;
                    game.inGamePlayers.remove(sender);
                    game.UpdateSign();
                    for (Player p : game.inGamePlayers) {
                        p.sendMessage(this.leaveMsg.replace("%player%", sender.getName()));
                    }
                    ((Player)sender).getInventory().clear();
                    if (game.started) {
                        game.playerQuit((Player)sender);
                    }
                    ((Player)sender).getInventory().setContents(game.playerInventoryMap.get(sender));
                    ((Player)sender).updateInventory();
                    ((Player)sender).setGameMode(game.playerGameModeMap.get(sender));
                    ((Player)sender).teleport(game.playerLocationMap.get(sender));
                    ((Player)sender).setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
                }
                for (Player p : Bukkit.getOnlinePlayers()) {
                    p.showPlayer((Player)sender);
                }
            } else {
                Game game = this.games.get(0);
                for (Player p : game.inGamePlayers) {
                    p.sendMessage(this.leaveMsg.replace("%player%", sender.getName()));
                }
                ((Player)sender).getInventory().clear();
                if (game.started) {
                    game.playerQuit((Player)sender);
                } else {
                    game.inGamePlayers.remove(sender);
                }
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(b);
                try {
                    out.writeUTF("Connect");
                    out.writeUTF("lobby");
                }
                catch (IOException ex) {
                    System.err.print("Could not connect to server! :/");
                    ex.printStackTrace();
                }
                ((Player)sender).sendPluginMessage((Plugin)this, "BungeeCord", b.toByteArray());
            }
        }
        if (cmd.getName().equalsIgnoreCase("reloadmsgs")) {
            this.reloadConfig();
            for (Game game : this.games) {
                game.ReloadMessages();
            }
            this.ReloadMessages();
        }
        if (cmd.getName().equalsIgnoreCase("setGamePos")) {
            if (args.length == 2) {
                yaml = this.getPlayerYaml(Integer.parseInt(args[0]));
                if (args[1].contains("house")) {
                    ((YamlPos)yaml).Add("Houses." + args[1] + ".x", ((Player)sender).getLocation().getBlockX());
                    ((YamlPos)yaml).Add("Houses." + args[1] + ".y", ((Player)sender).getLocation().getBlockY());
                    ((YamlPos)yaml).Add("Houses." + args[1] + ".z", ((Player)sender).getLocation().getBlockZ());
                } else if (args[1].contains("spawn")) {
                    ((YamlPos)yaml).Add("spawn.x", ((Player)sender).getLocation().getBlockX());
                    ((YamlPos)yaml).Add("spawn.y", ((Player)sender).getLocation().getBlockY());
                    ((YamlPos)yaml).Add("spawn.z", ((Player)sender).getLocation().getBlockZ());
                } else if (args[1].contains("corner")) {
                    ((YamlPos)yaml).Add(args[1] + ".x", ((Player)sender).getLocation().getBlockX());
                    ((YamlPos)yaml).Add(args[1] + ".y", ((Player)sender).getLocation().getBlockY());
                    ((YamlPos)yaml).Add(args[1] + ".z", ((Player)sender).getLocation().getBlockZ());
                } else if (args[1].contains("spec")) {
                    ((YamlPos)yaml).Add("spec.x", ((Player)sender).getLocation().getBlockX());
                    ((YamlPos)yaml).Add("spec.y", ((Player)sender).getLocation().getBlockY());
                    ((YamlPos)yaml).Add("spec.z", ((Player)sender).getLocation().getBlockZ());
                }
                ((YamlPos)yaml).Save();
                sender.sendMessage(ChatColor.GOLD + "Set position " + ChatColor.YELLOW + args[1] + ChatColor.GOLD + " for " + ChatColor.YELLOW + "game " + args[0] + ChatColor.GOLD + " to x: " + ((Player)sender).getLocation().getBlockX() + ", y: " + ((Player)sender).getLocation().getBlockY() + ", z: " + ((Player)sender).getLocation().getBlockZ());
            } else {
                sender.sendMessage(ChatColor.GOLD + "Oops! Make sure you specify a gameID and positionID e.g /setGamePos 1 house1");
            }
        }
        if (cmd.getName().equalsIgnoreCase("setGameSign")) {
            if (args.length == 1) {
                this.curGame = Integer.parseInt(args[0]);
                this.makingSign = true;
                sender.sendMessage(ChatColor.GOLD + "Click a sign to set the join sign!");
            } else {
                sender.sendMessage(ChatColor.GOLD + "You must specify the gameID e.g /setGameSign 1");
            }
        }
        return true;
    }

    void ReloadMessages() {
        this.joinMsg = this.getConfig().getString("Messages.All.Game.joinmsg").replace("&", "\u00a7");
        this.leaveMsg = this.getConfig().getString("Messages.All.Game.leavemsg").replace("&", "\u00a7");
    }

    @EventHandler
    public void onSignChange(SignChangeEvent e) {
        if (e.getLine(0).contains("[JOIN WITCH")) {
            e.setLine(0, "\u00a75" + e.getLine(0));
        }
    }

    @EventHandler
    public void interact(PlayerInteractEvent evt) {
        Sign s;
        if (this.makingSign) {
            evt.setCancelled(true);
            if (evt.getAction() == Action.RIGHT_CLICK_BLOCK || evt.getAction() == Action.LEFT_CLICK_BLOCK) {
                if (evt.getClickedBlock().getState() instanceof Sign) {
                    Block b = evt.getClickedBlock();
                    this.getConfig();
                    this.getConfig().set("JoinSigns.game" + this.curGame + ".x", (Object)b.getX());
                    this.getConfig().set("JoinSigns.game" + this.curGame + ".y", (Object)b.getY());
                    this.getConfig().set("JoinSigns.game" + this.curGame + ".z", (Object)b.getZ());
                    this.saveConfig();
                    evt.getPlayer().sendMessage(ChatColor.GOLD + "Set join sign for " + ChatColor.YELLOW + "game " + this.curGame + ChatColor.GOLD + " to x: " + b.getX() + ", y: " + b.getY() + ", z: " + b.getZ());
                } else {
                    evt.getPlayer().sendMessage(ChatColor.GOLD + "Join Sign cancelled - you must click a sign!");
                }
                this.makingSign = false;
            }
        } else if (evt.getAction() == Action.RIGHT_CLICK_BLOCK && evt.getClickedBlock().getState() instanceof Sign && (s = (Sign)evt.getClickedBlock().getState()).getLine(0).contains("[JOIN WITCH")) {
            int gameNumber = Integer.parseInt(s.getLine(0).replace("\u00a75[JOIN WITCH", "").replace("]", ""));
            if (!this.games.get((int)gameNumber).started) {
                this.games.get((int)gameNumber).inGamePlayers.add(evt.getPlayer());
                YamlPos yaml = this.getPlayerYaml(gameNumber);
                this.games.get((int)gameNumber).playerLocationMap.put(evt.getPlayer(), evt.getPlayer().getLocation());
                evt.getPlayer().teleport(new Location((World)this.getServer().getWorlds().get(0), (double)yaml.Get("spawn.x"), (double)yaml.Get("spawn.y"), (double)yaml.Get("spawn.z")));
                evt.getPlayer().setCollidable(true);
                evt.getPlayer().setInvulnerable(false);
                evt.getPlayer().setCanPickupItems(true);
                evt.getPlayer().setCollidable(true);
                evt.getPlayer().setCollidable(true);
                this.games.get(gameNumber).UpdateSign();
                this.games.get(gameNumber).PlayerJoinGame(evt.getPlayer());
                for (Player p : this.games.get((int)gameNumber).inGamePlayers) {
                    p.sendMessage(this.joinMsg.replace("%player%", evt.getPlayer().getName()).replace("%players%", this.games.get((int)gameNumber).inGamePlayers.size() + "").replace("%max%", "16"));
                }
            } else {
                evt.getPlayer().sendMessage(ChatColor.RED + "Kicked whilst joining the game: " + ChatColor.WHITE + "The game has already started, wait for it to finish!");
            }
        }
    }

    @EventHandler
    public void PlayerJoin(PlayerJoinEvent evt) {
        if (this.bungee) {
            this.games.get((int)0).inGamePlayers.add(evt.getPlayer());
            YamlPos yaml = this.getPlayerYaml(0);
            evt.getPlayer().teleport(new Location((World)this.getServer().getWorlds().get(0), (double)yaml.Get("spawn.x"), (double)yaml.Get("spawn.y"), (double)yaml.Get("spawn.z")));
            evt.getPlayer().setCollidable(true);
            evt.getPlayer().setInvulnerable(false);
            evt.getPlayer().setCanPickupItems(true);
            evt.getPlayer().setCollidable(true);
            evt.getPlayer().setCollidable(true);
            this.games.get(0).PlayerJoinGame(evt.getPlayer());
            evt.setJoinMessage(this.joinMsg.replace("%player%", evt.getPlayer().getName()).replace("%players%", this.games.get((int)0).inGamePlayers.size() + "").replace("%max%", "16"));
        }
    }

    @EventHandler
    public void PlayerQuit(PlayerQuitEvent evt) {
        if (this.bungee) {
            evt.setQuitMessage(null);
            this.games.get((int)0).inGamePlayers.remove(evt.getPlayer());
            if (this.games.get((int)0).started) {
                this.games.get(0).playerQuit(evt.getPlayer());
            }
        } else {
            for (Game game : this.games) {
                if (!game.inGamePlayers.contains(evt.getPlayer())) continue;
                game.inGamePlayers.remove(evt.getPlayer());
                game.UpdateSign();
                for (Player p : game.inGamePlayers) {
                    p.sendMessage(this.leaveMsg.replace("%player%", evt.getPlayer().getName()));
                }
                if (!game.started) continue;
                game.playerQuit(evt.getPlayer());
            }
        }
    }

    public YamlPos getPlayerYaml(int gameNum) {
        File file = new File(this.getDataFolder().getAbsolutePath() + File.separator + "data" + File.separator + "games" + File.separator + "Game" + gameNum + ".yml");
        return new YamlPos(file);
    }

    public Yaml getPlayerStatsYaml(String string) {
        File file = new File(this.getDataFolder().getAbsolutePath() + File.separator + "data" + File.separator + "players" + File.separator + string + ".yml");
        return new Yaml(file);
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent evt) throws IOException {
        if (this.enclosedChat) {
            boolean inGame = false;
            for (Game game : this.games) {
                if (!game.inGamePlayers.contains(evt.getPlayer())) continue;
                inGame = true;
                evt.getRecipients().removeIf(player -> !game.inGamePlayers.contains(player));
                if (!game.spectators.contains(evt.getPlayer())) continue;
                evt.setFormat(ChatColor.GREEN + "SPEC" + ChatColor.WHITE + " %s: %s");
                if (game.cancel) continue;
                evt.getRecipients().removeIf(player -> !game.spectators.contains(player));
            }
            if (!inGame) {
                for (Game game : this.games) {
                    evt.getRecipients().removeIf(player -> game.inGamePlayers.contains(player));
                }
            }
        }
    }
}

